from hashlib import md5

try:
    from urllib import urlencode
except ImportError:
    from urllib.parse import urlencode


class Gravatar(object):
    base_url = 'http://www.gravatar.com/avatar/'
    base_url_secure = 'https://secure.gravatar.com/avatar/'

    ratings = ('g', 'pg', 'r', 'x')

    def __init__(self, default_size=0, default_rating='', default_image='',
                 default_image_ext='', secure=True, force_default_image=False):
        self.default_size = default_size

        if default_rating and (not default_rating in self.ratings):
            raise ValueError('No such rating, expected one of: g, pg, r, x but got: ' + str(self.default_rating))

        self.default_rating = default_rating
        self.default_image = default_image
        self.default_image_ext = default_image_ext

        self.secure = secure
        self.force_default_image = force_default_image

    def get_url(self, email, size=0, rating='', default=''):
        gravatar_hash = md5(email.strip().lower().encode('utf-8')).hexdigest()

        # Build parameters
        parameters = [p for p in (
            ('d', default or self.default_image),
            ('s', size or self.default_size),
            ('r', rating or self.default_rating),
        ) if p[1]]

        url_parameters = urlencode(parameters, doseq=True)

        # Construct url
        gravatar_url = self.base_url

        if self.secure:
            gravatar_url = self.base_url_secure

        gravatar_url += gravatar_hash + self.default_image_ext
        if url_parameters:
            gravatar_url += '?' + url_parameters

        return gravatar_url
