from django import template
from django.conf import settings

from django_gravatar_tags.utils import Gravatar

register = template.Library()


def get_gravatar_instance():
    # Load default parameters from settings
    gravatar_image_ext = getattr(settings, 'GRAVATAR_IMAGE_EXT', '.jpg')
    gravatar_default_image = getattr(settings, 'GRAVATAR_DEFAULT_IMAGE', '')
    gravatar_rating = getattr(settings, 'GRAVATAR_RATING', '')
    gravatar_size = getattr(settings, 'GRAVATAR_SIZE', '')
    gravatar_secure = getattr(settings, 'GRAVATAR_SECURE', True)

    return Gravatar(default_size=gravatar_size,
                    default_rating=gravatar_rating,
                    default_image=gravatar_default_image,
                    default_image_ext=gravatar_image_ext,
                    secure=gravatar_secure)


@register.simple_tag
def gravatar(user_or_email, size=0, rating='', default='', force_default=False, css_class='gravatar', alt=''):
    g = get_gravatar_instance()

    email = user_or_email
    if hasattr(user_or_email, 'email'):
        email = user_or_email.email

    gravatar_url = g.get_url(email, size, rating, default)

    img_template = '<img class="{css_class}" alt="{alt}" width="{size}" height="{size}" src="{src}" />'

    return img_template.format(css_class=css_class,
                               alt=alt,
                               size=size or 80,
                               src=gravatar_url)


@register.simple_tag
def gravatar_url(user_or_email, size=0, rating='', default='', force_default=False):
    g = get_gravatar_instance()

    email = user_or_email
    if hasattr(user_or_email, 'email'):
        email = user_or_email.email

    return g.get_url(email, size, rating, default)
