from django.test import SimpleTestCase, TestCase
from django.template import Context, Template

from django_gravatar_tags.utils import Gravatar


class TestUnit(SimpleTestCase):
    def test_simple(self):
        email = 'ihavean@email.com'
        expected_result = 'https://secure.gravatar.com/avatar/3b3be63a4c2a439b013787725dfce802'
        result = Gravatar().get_url(email)

        self.assertEqual(result, expected_result)

    def test_with_parameters(self):
        email = 'ihavean@email.com'
        expected_result = 'https://secure.gravatar.com/avatar/3b3be63a4c2a439b013787725dfce802?s=48&r=g'
        result = Gravatar().get_url(email, 48, 'g')

        self.assertEqual(result, expected_result)


class TestIntegration(TestCase):
    def test_gravatar_tag_simple(self):
        result = Template("{% load gravatar %}{% gravatar 'test@example.com' %}").render(Context())
        self.assertEqual(result, '<img class="gravatar" alt="" width="80" height="80" src="https://secure.gravatar.com/avatar/55502f40dc8b7c769880b10874abc9d0.jpg" />')

    def test_gravatar_url_tag_simple(self):
        result = Template("{% load gravatar %}{% gravatar_url 'test@example.com' %}").render(Context())
        self.assertEqual(result, 'https://secure.gravatar.com/avatar/55502f40dc8b7c769880b10874abc9d0.jpg')
