//@ sourceMappingURL=jquery.django.ajax.map
// Generated by CoffeeScript 1.6.1
(function() {

  jQuery(function($) {
    "use strict";
    var ajax, ajaxify, can_navigate, dj, get_block, has_ajax_blocks, init, init_blocks, load_blocks, reload_ajax, require_js_blocks, validate_blocks, _app_name, _block_cache, _block_names, _blocks;
    dj = $.dj = $.dj || {};
    ajax = dj.ajax = dj.ajax || {};
    _block_cache = {};
    _block_names = [];
    _blocks = void 0;
    _app_name = void 0;
    init_blocks = function() {
      var block_name;
      _blocks = window.__ajax_blocks;
      _app_name = window.__app_name;
      for (block_name in _blocks) {
        _block_names.push(block_name);
      }
      return delete window.__ajax_blocks;
    };
    init = function() {
      ajax.load_blocks = load_blocks;
      ajax.reload_ajax = reload_ajax;
      ajax.has_ajax_blocks = has_ajax_blocks;
      ajax.ajaxify = ajaxify;
      ajax.can_navigate = can_navigate;
      return ajax.init_blocks = init_blocks;
    };
    get_block = function(id) {
      var elem;
      elem = _block_cache[id];
      if (!elem) {
        elem = $("#" + id);
        _block_cache[id] = elem;
      }
      return elem;
    };
    validate_blocks = function(block_names) {
      var block_name, _i, _len, _results;
      _results = [];
      for (_i = 0, _len = block_names.length; _i < _len; _i++) {
        block_name = block_names[_i];
        if (!(block_name in _blocks)) {
          throw "Invalid AJAX Template Block :" + block_name;
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };
    require_js_blocks = function(js, callback) {
      var block, count, require_callback, total, _i, _len, _results;
      total = js.length;
      if (total === 0) {
        callback();
      }
      count = 0;
      require_callback = function() {
        count += 1;
        if (count === total) {
          return callback();
        }
      };
      _results = [];
      for (_i = 0, _len = js.length; _i < _len; _i++) {
        block = js[_i];
        _results.push(require(block.files, require_callback));
      }
      return _results;
    };
    load_blocks = function(url, blocks, parent) {
      var data, options;
      if (blocks == null) {
        blocks = _block_names;
      }
      if (parent == null) {
        parent = window;
      }
      validate_blocks(blocks);
      data = $.param({
        __blocks__: blocks,
        __app_name__: _app_name || ""
      });
      options = {
        url: url,
        data: data,
        type: 'get',
        dataType: 'json',
        headers: {
          'X-DJANGO-AJAX-RENDERER': 'true'
        },
        error: function() {
          return console.log('Error occured.');
        },
        success: function(obj) {
          var js, require_callback, win;
          win = window;
          js = obj.js;
          blocks = obj.blocks;
          require_callback = function() {
            var block, block_contents, block_name, elem, _i, _len;
            for (block_name in blocks) {
              block_contents = blocks[block_name];
              elem = get_block(block_name);
              elem.html(block_contents);
            }
            for (_i = 0, _len = js.length; _i < _len; _i++) {
              block = js[_i];
              $.globalEval(block.js_code);
            }
            $(parent).trigger('djang-ajax-rendered', url, blocks);
            win.location.hash = url;
            if (obj.title) {
              return document.title = obj.title;
            }
          };
          return require_js_blocks(js, require_callback);
        }
      };
      return $.ajax(options);
    };
    reload_ajax = function(blocks) {
      if (blocks == null) {
        blocks = _block_names;
      }
      return load_blocks(this.location, blocks);
    };
    has_ajax_blocks = function() {
      return _block_names.length > 0;
    };
    ajaxify = function(id) {
      if (id == null) {
        id = window;
      }
      return $(id).on("click", "a", function() {
        var $this, href;
        if (!has_ajax_blocks()) {
          console.log("No AJAX Blocks");
          return;
        }
        $this = $(this);
        href = $this.attr('href');
        if (can_navigate(href) === false) {
          return;
        }
        load_blocks(href, _block_names, this);
        return false;
      });
    };
    can_navigate = function(url) {
      var first, http, https;
      first = url[0];
      if (first === "#") {
        return false;
      }
      http = url.slice(0, 7);
      https = url.slice(0, 8);
      if (http === "http://" || https === "https://") {
        return false;
      }
      return true;
    };
    return init();
  });

}).call(this);
