//@ sourceMappingURL=jquery.validate.django.map
// Generated by CoffeeScript 1.6.1
(function() {

  $.dj = $.dj || {};

  jQuery(function($) {
    var elementValue;
    elementValue = function(element) {
      var $elem, sel, type, val;
      $elem = $(element);
      type = $elem.attr("type");
      val = $elem.val();
      if (type === "radio" || type === "checkbox") {
        sel = "input[name='" + $elem.attr("name") + "']:checked";
        val = $(sel).val();
        return val;
      }
      if (typeof val === "string") {
        return val.replace(/\r/g, "");
      }
      return val;
    };
    return $.dj.msgs = {
      sprintf_length: function(msg) {
        return function(params, element) {
          var obj, value;
          value = elementValue(element).length;
          obj = {
            limit_value: params,
            show_value: value
          };
          return sprintf(msg, obj);
        };
      },
      sprintf_value: function(msg) {
        return function(params, element) {
          var obj, value;
          value = elementValue(element);
          obj = {
            limit_value: params,
            show_value: value
          };
          return sprintf(msg, obj);
        };
      },
      sprintf_params: function(msg) {
        return function(params) {
          return sprintf(msg, params);
        };
      }
    };
  });

  jQuery(function($) {
    var get_decimals, get_digits, validator;
    validator = $.validator;
    get_digits = function(val) {
      var i;
      i = val.indexOf(".");
      if (i === -1) {
        return val;
      }
      return val.substr(0, i);
    };
    get_decimals = function(val) {
      var i;
      i = val.indexOf(".");
      if (i === -1) {
        return "";
      }
      return val.substr(i + 1);
    };
    validator.addMethod("integer", function(value, element, params) {
      var new_val;
      if (this.optional(element)) {
        return true;
      }
      if (!params) {
        return true;
      }
      new_val = parseInt(value, 10);
      return new_val + "" === value;
    });
    validator.addMethod("max_digits", function(value, element, params) {
      var decimals, digits;
      if (this.optional(element)) {
        return true;
      }
      digits = get_digits(value);
      decimals = get_decimals(value);
      return digits.length + decimals.length <= params;
    });
    validator.addMethod("max_decimal_places", function(value, element, params) {
      var decimals;
      if (this.optional(element)) {
        return true;
      }
      decimals = get_decimals(value);
      return decimals.length <= params;
    });
    validator.addMethod("max_whole_digits", function(value, element, params) {
      var digits;
      if (this.optional(element)) {
        return true;
      }
      digits = get_digits(value);
      return digits.length <= params;
    });
    return validator.addMethod("math", function(value, element) {
      if (this.optional(element)) {
        return true;
      }
    });
  });

  jQuery(function($) {
    var defaultCache, dj, getCache, getErrorClass, getErrorElement, getErrorPlacement, getHighlight, getSuccess, getValidClass, getValue, getValueGetter, getValueSetter, setValue, valueCaches;
    valueCaches = {};
    defaultCache = {};
    if ($.dj === void 0) {
      $.dj = {};
    }
    dj = $.dj;
    getCache = function(name) {
      if (valueCaches[name] === void 0) {
        valueCaches[name] = {};
      }
      return valueCaches[name];
    };
    setValue = function(name, val, override, cache_name) {
      var cache;
      cache = getCache(cache_name);
      if (cache[name] === void 0 || override === true) {
        return cache[name] = val;
      } else {
        if (cache[name] !== void 0) {
          throw "Already exists.";
        }
      }
    };
    getValueSetter = function(cache_name) {
      return function(name, val, override) {
        return setValue(name, val, override, cache_name);
      };
    };
    getValue = function(name, cache_name, d) {
      var cache, val;
      cache = getCache(cache_name);
      val = cache[name];
      if (val === void 0 && d === true) {
        val = defaultCache[cache_name];
      }
      return val;
    };
    getValueGetter = function(cache_name) {
      return function(name, base, options) {
        var val;
        val = getValue(name, cache_name, base === void 0);
        if (val === void 0 && base !== void 0) {
          val = getValue(name, base, cache_name);
        }
        if (val !== void 0) {
          options[cache_name] = val;
        }
        return val;
      };
    };
    dj.setErrorPlacement = getValueSetter("errorPlacement");
    dj.setSuccess = getValueSetter("success");
    dj.setHighlight = getValueSetter("highlight");
    dj.setErrorClass = getValueSetter("errorClass");
    dj.setValidClass = getValueSetter("validClass");
    dj.setErrorElement = getValueSetter("errorElement");
    getErrorPlacement = getValueGetter("errorPlacement");
    getSuccess = getValueGetter("success");
    getHighlight = getValueGetter("highlight");
    getErrorClass = getValueGetter("errorClass");
    getValidClass = getValueGetter("validClass");
    getErrorElement = getValueGetter("errorElement");
    dj.setDefault = function(name, val, override) {
      if (defaultCache[name] === void 0 || override) {
        return defaultCache[name] = val;
      } else {
        if (defaultCache[name] !== void 0) {
          throw "Already exists.";
        }
      }
    };
    return dj.validate = function(form_id, rules, messages, validation_base) {
      var form, options;
      if (validation_base === "") {
        validation_base = void 0;
      }
      form = $(form_id);
      options = {
        rules: rules,
        messages: messages
      };
      getErrorElement(form_id, validation_base, options);
      getErrorClass(form_id, validation_base, options);
      getErrorPlacement(form_id, validation_base, options);
      getSuccess(form_id, validation_base, options);
      getHighlight(form_id, validation_base, options);
      getValidClass(form_id, validation_base, options);
      return form.validate(options);
    };
  });

}).call(this);
