//@ sourceMappingURL=django-helpers-require.map
// Generated by CoffeeScript 1.6.1
(function() {
  var __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  jQuery(function($) {
    /** 
        @author Muhammed K K
        @date-created 22/7/13, 3:46 PM
        The list of already loaded files.
    */

    var add_callback, evaluate, invoke_callbacks, load_js, require, __callbacks, __evaluated_files, __loaded_files, __waiting_list;
    __loaded_files = [];
    /**
        @author Muhammed K K
        @date-created 22/7/13, 3:46 PM
        List of files witing to be loaded.
    */

    __waiting_list = [];
    /** 
        @author Muhammed K K
        @date-created 22/7/13, 3:46 PM
        Dictionary which has all the callbacks registered for a
        Javascript file.
    */

    __callbacks = {};
    /**
        @author Muhammed K K
        @date-created 22/7/13, 3:47 PM
        A list of already evaluated Javascript Files.
    */

    __evaluated_files = [];
    /**
        @author Muhammed K K
        @date-created 22/7/13, 3:48 PM
        Register a callback for a Javascript file.
        When the file is loaded all the callbacks
        will be executed.
    */

    add_callback = function(js, callback) {
      var callbacks;
      callbacks = __callbacks[js];
      if (!callbacks) {
        callbacks = [];
        __callbacks[js] = callbacks;
      }
      return callbacks.push(callback);
    };
    /**
        @author Muhammed K K
        @date-created 22/7/13, 3:50 PM
        Executes the loaded js file and adds it to a list of executed files.
    */

    evaluate = function(js, code) {
      if (__indexOf.call(__evaluated_files, js) >= 0) {
        return;
      }
      $.globalEval(code);
      return __evaluated_files.push(js);
    };
    /**
        @author Muhammed K K
        @date-created 22/7/13, 3:51 PM
        Invokes the callbacks for the javascript the given
        javascript file and removes it from the queue.
    */

    invoke_callbacks = function(js, content) {
      var callback, callbacks, _i, _len;
      callbacks = __callbacks[js];
      for (_i = 0, _len = callbacks.length; _i < _len; _i++) {
        callback = callbacks[_i];
        callback(js, content);
      }
      return delete __callbacks[js];
    };
    load_js = function(js, callback) {
      if (__indexOf.call(__loaded_files, js) >= 0) {
        return callback(js, void 0);
      }
      add_callback(js, callback);
      if (__indexOf.call(__waiting_list, js) >= 0) {
        return;
      }
      __waiting_list.push(js);
      return $.get(js, function(contents) {
        var i;
        i = __waiting_list.indexOf(js);
        __waiting_list.splice(i, 1);
        __loaded_files.push(js);
        return invoke_callbacks(js, contents);
      });
    };
    require = function(js_files, callback) {
      var current, js, js_loadede, loaded_data, total, _i, _len, _results;
      current = 0;
      total = js_files.length;
      if (total === 0) {
        callback();
      }
      loaded_data = {};
      js_loadede = function(js, loaded_contents) {
        var contents, _i, _len;
        loaded_data[js] = loaded_contents;
        current += 1;
        if (current === total) {
          for (_i = 0, _len = js_files.length; _i < _len; _i++) {
            js = js_files[_i];
            contents = loaded_data[js];
            if (contents) {
              delete loaded_data[js];
              evaluate(js, contents);
            }
          }
          return callback();
        }
      };
      _results = [];
      for (_i = 0, _len = js_files.length; _i < _len; _i++) {
        js = js_files[_i];
        _results.push(load_js(js, js_loadede));
      }
      return _results;
    };
    return window.require = require;
  });

}).call(this);
