# -*- coding: utf-8 -*-
# 
#  setup.py
#  django-hierarchy
#  
#  Created by Lars Yencken on 2009-04-09.
#  Copyright 2009 Lars Yencken. All rights reserved.
# 

from setuptools import setup

VERSION = '0.1.0'

f = open('src/__version__.py', 'w')
f.write('# Autogenerated by setup.py\n')
f.write('version = "%s"\n' % VERSION)
f.close()

setup(
        name='django-hierarchy',
        description="A library for storing trees in the Django ORM.",
        long_description = """
        Provides abstract hierarchical tables, and access methods on them, for
        use with the Django ORM.
        """,
        url="http://bitbucket.org/lars512/django-hierarchy/",
        version=VERSION,
        author="Lars Yencken",
        author_email="lljy@csse.unimelb.edu.au",
        license="BSD",

        package_dir={'hierarchy': 'src'},
        packages=['hierarchy'],
    )
