from djangohelpers.middleware import path_matches

class CatchInactiveUsersMiddleware(object):
    def process_request(self, request):
        if request.path == reverse('inactive-user'):
            return None

        if path_matches(request.path, getattr(settings, 'ANONYMOUS_PATHS', [])):
            return None

        if not request.user.is_authenticated():
            return None

        if request.user.is_authenticated() and not request.user.is_active:

            # todo: add a cfgable notification/flash/portalstatus message callback 
            #       somehow (settings.py i guess :-/)

            response = HttpResponseRedirect(reverse('inactive-user'))
            response.status_code = 307  # please don't cache?
            return response
