from django.conf import settings
from django.contrib import admin

from informativo.models import Contact, MailingList, Newsletter


class ContactAdmin(admin.ModelAdmin):
    list_display  = ('email', 'first_name', 'last_name')
    list_filter   = ('mailing_lists',)
    search_fields = ('email', 'first_name', 'last_name')


class MailingListAdmin(admin.ModelAdmin):
    search_fields = ('name', 'description')


class NewsletterAdmin(admin.ModelAdmin):
    list_display  = ('title', 'mailing_list', 'sending_date', 'status')
    list_filter   = ('status',)
    radio_fields = {'mailing_list': admin.VERTICAL}
    readonly_fields = ('status',)
    search_fields = ('title', 'html_content', 'text_content')


admin.site.register(Contact, ContactAdmin)
admin.site.register(MailingList, MailingListAdmin)
admin.site.register(Newsletter, NewsletterAdmin)


if settings.DEBUG:
    from informativo.models import ContactMailingStatus
    admin.site.register(ContactMailingStatus)
