# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Contact'
        db.create_table('informativo_contact', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=75)),
            ('first_name', self.gf('django.db.models.fields.CharField')(max_length=64)),
            ('last_name', self.gf('django.db.models.fields.CharField')(max_length=64)),
        ))
        db.send_create_signal('informativo', ['Contact'])

        # Adding M2M table for field mailing_lists on 'Contact'
        db.create_table('informativo_contact_mailing_lists', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('contact', models.ForeignKey(orm['informativo.contact'], null=False)),
            ('mailinglist', models.ForeignKey(orm['informativo.mailinglist'], null=False))
        ))
        db.create_unique('informativo_contact_mailing_lists', ['contact_id', 'mailinglist_id'])

        # Adding model 'MailingList'
        db.create_table('informativo_mailinglist', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=64)),
            ('description', self.gf('django.db.models.fields.TextField')(blank=True)),
        ))
        db.send_create_signal('informativo', ['MailingList'])

        # Adding model 'Newsletter'
        db.create_table('informativo_newsletter', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('html_content', self.gf('django.db.models.fields.TextField')(blank=True)),
            ('text_content', self.gf('django.db.models.fields.TextField')(blank=True)),
            ('mailing_list', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['informativo.MailingList'])),
            ('sending_date', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)),
            ('status', self.gf('django.db.models.fields.CharField')(default='waiting', max_length=16)),
        ))
        db.send_create_signal('informativo', ['Newsletter'])

        # Adding model 'ContactMailingStatus'
        db.create_table('informativo_contactmailingstatus', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('contact', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['informativo.Contact'])),
            ('newsletter', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['informativo.Newsletter'])),
            ('status', self.gf('django.db.models.fields.CharField')(max_length=16)),
        ))
        db.send_create_signal('informativo', ['ContactMailingStatus'])

    def backwards(self, orm):
        # Deleting model 'Contact'
        db.delete_table('informativo_contact')

        # Removing M2M table for field mailing_lists on 'Contact'
        db.delete_table('informativo_contact_mailing_lists')

        # Deleting model 'MailingList'
        db.delete_table('informativo_mailinglist')

        # Deleting model 'Newsletter'
        db.delete_table('informativo_newsletter')

        # Deleting model 'ContactMailingStatus'
        db.delete_table('informativo_contactmailingstatus')

    models = {
        'informativo.contact': {
            'Meta': {'ordering': "('-id',)", 'object_name': 'Contact'},
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'mailing_lists': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'subscribers'", 'symmetrical': 'False', 'to': "orm['informativo.MailingList']"})
        },
        'informativo.contactmailingstatus': {
            'Meta': {'ordering': "('-id',)", 'object_name': 'ContactMailingStatus'},
            'contact': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['informativo.Contact']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'newsletter': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['informativo.Newsletter']"}),
            'status': ('django.db.models.fields.CharField', [], {'max_length': '16'})
        },
        'informativo.mailinglist': {
            'Meta': {'ordering': "('-id',)", 'object_name': 'MailingList'},
            'description': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'informativo.newsletter': {
            'Meta': {'ordering': "('-id',)", 'object_name': 'Newsletter'},
            'html_content': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'mailing_list': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['informativo.MailingList']"}),
            'sending_date': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'waiting'", 'max_length': '16'}),
            'text_content': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '128'})
        }
    }

    complete_apps = ['informativo']