from django.core.urlresolvers import reverse
from django.views import generic

from informativo import forms
from informativo import models


class SubscribeFormView(generic.edit.FormView):
    form_class = forms.SubscribeForm
    template_name = 'informativo/subscribe_form.html'

    def form_valid(self, form):
        response = super(SubscribeFormView, self).form_valid(form)
        form.subscribe()
        return response

    def get_context_data(self, **kwargs):
        context = super(SubscribeFormView, self).get_context_data(**kwargs)
        context['unsubscribe_form'] = forms.UnsubscribeForm
        return context

    def get_success_url(self):
        return reverse('informativo-subscribed')


class SubscribedView(generic.base.TemplateView):
    template_name = 'informativo/subscribed.html'


class UnsubscribeFormView(generic.edit.FormView):
    form_class = forms.UnsubscribeForm
    template_name = 'informativo/unsubscribe_form.html'

    def form_valid(self, form):
        response = super(UnsubscribeFormView, self).form_valid(form)
        contact = form.unsubscribe()
        if not contact.mailing_lists.all():
            contact.delete()
        return response

    def get_success_url(self):
        return reverse('informativo-unsubscribed')


class UnsubscribedView(generic.base.TemplateView):
    template_name = 'informativo/unsubscribed.html'
