# Copyright (c) 2010-2013 by Yaco Sistemas <ant30tx@gmail.com> or <goinnn@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this programe.  If not, see <http://www.gnu.org/licenses/>.

import re

from django.core.management.commands import makemessages
from django.utils.translation import trans_real


class Command(makemessages.Command):

    def handle(self, *args, **options):
        new_patthern = trans_real.inline_re.pattern.replace('trans', '(?:trans|inline_trans|itrans)')
        trans_real.inline_re = re.compile(new_patthern)
        return super(Command, self).handle(*args, **options)
