/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.activation.FileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jruby.webapp.util.FileUtil;

public class FileServlet
extends HttpServlet {
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    public static final String FALLBACK_SERVLET_PROPERTY = "files.default";
    private static final String[] DEFAULT_WELCOME_FILES = new String[]{"index.html", "index.htm"};
    public static final String CACHE_CONTROL_HEADER = "Cache-Control";
    public static final String EXPIRES_HEADER = "Expires";
    public static final String DATE_HEADER = "Date";
    private int bufferSize = 1024;
    private File root;
    private String prefix;
    private boolean setCacheHeaders;
    private int maxAge;
    private String defaultServletDispatcherName;

    public void init() throws ServletException {
        this.prefix = this.findPrefix();
        this.root = this.findRoot();
        boolean bl = this.setCacheHeaders = this.getServletConfig().getInitParameter("maxAge") != null;
        if (this.setCacheHeaders) {
            this.maxAge = Integer.parseInt(this.getServletConfig().getInitParameter("maxAge"));
        }
        ServletContext servletContext = this.getServletContext();
        String string = this.getServletConfig().getInitParameter("defaultServlet");
        if (string == null) {
            string = servletContext.getInitParameter(FALLBACK_SERVLET_PROPERTY);
        }
        if (string != null && string.length() != 0) {
            this.defaultServletDispatcherName = string;
        }
    }

    protected String findPrefix() {
        String string = this.getServletContext().getInitParameter("files.prefix");
        if (string == null) {
            string = "/public";
        }
        if (string.length() > 0 && !string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    protected File findRoot() throws ServletException {
        File file;
        String string = this.getServletContext().getInitParameter("files.root");
        if (string == null) {
            string = FileUtil.getPath(this.getServletContext(), "/");
        }
        if (!(file = new File(string)).isDirectory()) {
            throw new ServletException("Webapp root does not point to a directory");
        }
        return file;
    }

    public String[] getWelcomeFiles() {
        String string = this.getServletContext().getInitParameter("files.welcome");
        String[] stringArray = string != null ? this.parseCommaList(string) : DEFAULT_WELCOME_FILES;
        return stringArray;
    }

    private String[] parseCommaList(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    protected File getFile(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getRequestURI().substring(string.length());
        string2 = string2.replaceAll("\\\\", "/").replaceAll("//", "/");
        String string3 = this.root == null ? this.prefix + string2 : this.root.getAbsolutePath() + this.prefix + string2;
        return this.getFile(string3);
    }

    protected File getFile(String string) {
        File file = this.getExactFile(string);
        if (file != null) {
            return file;
        }
        file = this.getExactFile(string + ".html");
        if (file != null) {
            return file;
        }
        String[] stringArray = this.getWelcomeFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            file = this.getExactFile(string + "/" + stringArray[i]);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    protected File getExactFile(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    private String formatDateForHeader(Date date) {
        String string = "EEE, d MMM yyyy HH:mm:ss z";
        return new SimpleDateFormat(string).format(date);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            Object object;
            File file = this.getFile(httpServletRequest);
            if (file == null) {
                if (this.defaultServletDispatcherName != null) {
                    this.getServletContext().getNamedDispatcher(this.defaultServletDispatcherName).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                this.log("File not found: " + httpServletRequest.getRequestURI());
                throw new FileNotFoundException(httpServletRequest.getRequestURI());
            }
            long l = httpServletRequest.getDateHeader("If-Modified-Since");
            long l2 = file.lastModified();
            if (l2 > 0L) {
                httpServletResponse.setDateHeader("Last-Modified", l2);
                if (l != -1L && l2 <= l) {
                    throw new NotModifiedException();
                }
            }
            if (this.setCacheHeaders) {
                httpServletResponse.setHeader(CACHE_CONTROL_HEADER, "max-age=" + this.maxAge);
                object = Calendar.getInstance();
                httpServletResponse.setHeader(DATE_HEADER, this.formatDateForHeader(((Calendar)object).getTime()));
                ((Calendar)object).add(13, this.maxAge);
                httpServletResponse.setHeader(EXPIRES_HEADER, this.formatDateForHeader(((Calendar)object).getTime()));
            }
            object = this.guessContentTypeFromName(file.getName());
            httpServletResponse.setContentType((String)object);
            if (!httpServletRequest.getMethod().equals(METHOD_HEAD)) {
                if (httpServletRequest.getMethod().equals(METHOD_GET) || httpServletRequest.getMethod().equals(METHOD_POST)) {
                    this.sendFile(file, httpServletResponse);
                } else {
                    httpServletResponse.sendError(501);
                }
            }
        }
        catch (NotModifiedException notModifiedException) {
            httpServletResponse.setStatus(304);
        }
        catch (FileNotFoundException fileNotFoundException) {
            httpServletResponse.sendError(404);
        }
        catch (IOException iOException) {
            httpServletResponse.sendError(500, iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File file, HttpServletResponse httpServletResponse) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.bufferSize);
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            while (fileChannel.read(byteBuffer) != -1) {
                servletOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
                byteBuffer.clear();
            }
            servletOutputStream.close();
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String guessContentTypeFromName(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".css")) {
            return "text/css";
        }
        if (string2.endsWith(".js")) {
            return "text/js";
        }
        try {
            FileTypeMap fileTypeMap = FileTypeMap.getDefaultFileTypeMap();
            return fileTypeMap.getContentType(string);
        }
        catch (Throwable throwable) {
            return "application/octet-stream";
        }
    }

    private static class NotModifiedException
    extends IOException {
    }
}

