from django import template
from django.utils.encoding import force_unicode
from django.utils.safestring import mark_safe
import markdown as markitdown

register = template.Library()


@register.filter(is_safe=True)
def markdown(value, args=''):
    """
    Runs Markdown over a given value, optionally using various
    extensions python-markdown supports.

    Syntax::

        {{ value|markdown:"extension1_name,extension2_name..." }}

    To enable safe mode, which strips raw HTML and only returns HTML
    generated by actual Markdown syntax, pass "safe" as the first
    extension in the list.

    If the version of Markdown in use does not support extensions,
    they will be silently ignored.
    """
    extensions = [e for e in args.split(',') if e]
    if len(extensions) > 0 and extensions[0] == "safe":
        extensions = extensions[1:]
        safe_mode = True
    else:
        safe_mode = False

    return mark_safe(markitdown.markdown(
        force_unicode(value),
        extensions,
        safe_mode=safe_mode,
        enable_attributes=(not safe_mode)
    ))
