from django.utils.importlib import import_module
from django.conf import settings as django_settings
from littlebro.conf import defaults

class Settings(object):
    "Simple wrapper around config."
    def __init__(self, module_name, prefix=''):
        self.module = import_module(module_name)
        self.prefix = prefix

    def __getattr__(self, name):
        p_name = '_'.join((self.prefix, name))
        if hasattr(django_settings, p_name):
            return getattr(django_settings, p_name)
        return getattr(self.module, name)

    def __dir__(self):
        return dir(self.module)

settings = Settings(defaults.__name__, 'LITTLEBRO')