from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt
from django.utils import simplejson

from livestats.models import RegistrationType, Registration, EntityType, Entity
import datetime

@csrf_exempt
def receiver(request):
        data = simplejson.loads(request.raw_post_data)
        et = EntityType.objects.get(name="Servers")
        for d in data:
                print d.get("host", None)
                e, created = Entity.objects.get_or_create(type=et, name=d["host"])
                value_names = d.get("dsnames", ["value_%s" % str(i+1) for i in range(0, len(d["values"])) if len(d["values"]) > 1]) or ["value"]
                print value_names
                for type, value in zip(value_names, d["values"]):
                        variable_name = "_".join([d["type"], d["type_instance"], type])
                        rt = RegistrationType.objects.filter(variable_name=variable_name)
                        if rt.count() > 0:
                                rt = rt[0]
                        else:
                                rt = RegistrationType.objects.create(variable_name=variable_name,\
                                                                     title=variable_name,\
                                                                     type="AVG")
                        Registration.objects.create(type=rt, value=value, entity=e, date=datetime.datetime.now())
        return HttpResponse("")
