from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt
from django.utils import simplejson

from livestats.models import RegistrationType, Registration, EntityType, Entity
import datetime

@csrf_exempt
def receiver(request):
        data = simplejson.loads(request.raw_post_data)
        et = EntityType.objects.get(name="Servers")
        date_from = datetime.datetime(year=datetime.datetime.now().year,
            month=datetime.datetime.now().month, day=datetime.datetime.now().day)

        date_to = datetime.datetime(year=datetime.datetime.now().year,
            month=datetime.datetime.now().month, day=datetime.datetime.now().day) - datetime.timedelta(minutes=1) + datetime.timedelta(days=1)

        for d in data:
                e, created = Entity.objects.get_or_create(type=et, name=d["host"])
                value_names = d.get("dsnames", ["value_%s" % str(i+1) for i in range(0, len(d["values"])) if len(d["values"]) > 1]) or ["value"]
                for type, value in zip(value_names, d["values"]):
                        variable_name = "_".join([d["type"], d["type_instance"], type])
                        rt = RegistrationType.objects.filter(variable_name=variable_name)
                        if len(str(value)) > 10:
                            value = value/1024
                        if rt.count() > 0:
                                rt = rt[0]
                        else:
                                rt = RegistrationType.objects.create(variable_name=variable_name,\
                                                                     title=variable_name,\
                                                                     type="LATEST")
                        r = Registration.objects.filter(date__range=(date_from, date_to), entity=e, type=rt)
                        if r.count() == 0:
                            Registration.objects.create(type=rt, value=value, entity=e, date=datetime.datetime.now())
                        else:
                            r[0].value = value
                            r[0].date = datetime.datetime.now()
                            r[0].save()
        return HttpResponse("")
