import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

setup(
    name='django-localflavor-us',
    version='1.1',
    description='Country-specific Django helpers for U.S.A.',
    long_description=README,
    author='Django Software Foundation',
    author_email='foundation@djangoproject.com',
    license='BSD',
    url='https://github.com/django/django-localflavor-us',
    packages=['django_localflavor_us'],
    include_package_data=True,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
    ],
    install_requires=[
        'Django>=1.4',
    ],
    tests_require=['Django >= 1.4.2'],
    test_suite='runtests.main',
)
