Django Mailgun Validation
=========================

This is a Django app that provides fields (for models and forms) that use 
Mailgun's validation API for validating email address.

The documentation on Mailgun's validation API is here:

http://documentation.mailgun.com/api-email-validation.html

See this blog post for more info on why it is a good idea to use this service
and not just rely on Django's built-in email validation:

http://blog.mailgun.com/post/free-email-validation-api-for-web-forms/

Usage:

```
pip install django-mailgun-validation
```

Alternatively:

```
pip install git+git://github.com/gnrfan/django-mailgun-validation.git
```

Using the validator:

```python
from mailgun_validation.validators import validate_email
status = validate_email('john.smith@gmail.com')
```

If the result is ```None``` the email address is OK but if an exception is
raised, the validation did not succeded.

Both model and form fields can use Mailgun's validation API or fall back to
using Django's built-in email validation:

```python
>>> from mailgun_validation.db.models.fields import EmailField
>>> f = EmailField()
>>> f.default_validators
[<mailgun_validation.validators.EmailValidator object at 0x10bed3d90>]
>>> f = EmailField(use_mailgun=False)
>>> f.default_validators
[<django.core.validators.EmailValidator object at 0x10bb3a790>]
```

The same for the forms field:

```python
>>> from mailgun_validation.forms.fields import EmailField
>>> f = EmailField()
>>> f.default_validators
[<mailgun_validation.validators.EmailValidator object at 0x10bed3d90>]
>>> f = EmailField(use_mailgun=False)
>>> f.default_validators
[<django.core.validators.EmailValidator object at 0x10bb3a790>]
```

In your Django project settings make sure to add your Mailgun API key:

```python
MAILGUN_API_KEY = '<your Mailgun API key goes here>'
```

In order for this code to work please install the Mailgun API Python wrapper
from this Github repo:

You can do just that by running this command:

```
pip install git+git://github.com/gnrfan/mailgun-python-api.git
```

(c) 2013-2014 - Antonio Ognio <antonio@ognio.com>
