# -*- coding: utf-8 -*-

from django.utils.translation import ugettext_lazy as _


CURRENCY_CHOICES = (
    ('USD', u'$'),
    ('EUR', u'€'),
    ('GBP', u'£'),
    ('AUD', u'$AUD'),
    ('CAD', u'$CAD'),
    ('SGD', u'$SGD'),
    ('HKD', u'$HKD'),
    ('NZD', u'$NZD'),
    ('MXN', u'$MXN'),
    ('BRL', u'R$'),
    ('CZK', u'Kč'),
    ('DKK', u'kr DKK'),
    ('SEK', u'kr SEK'),
    ('NOK', u'kr NOK'),
    ('HUF', u'Ft'),
    ('ILS', u'₪'),
    ('JPY', u'¥'),
    ('MYR', u'RM'),
    ('PHP', u'Php'),
    ('PLN', u'zł'),
    ('CHF', u'CHF'),
    ('TWD', u'NT$'),
    ('THB', u'฿'),
)

CURRENCY_LABELS = (
    ('USD', _(u'United States Dollar')),
    ('EUR', _(u'Euro')),
    ('GBP', _(u'British Pound')),
    ('AUD', _(u'Australian Dollar')),
    ('CAD', _(u'Canadian Dollar')),
    ('SGD', _(u'Singapore Dollar')),
    ('HKD', _(u'Hong Kong Dollar')),
    ('NZD', _(u'New Zealand Dollar')),
    ('MXN', _(u'Mexican Peso')),
    ('BRL', _(u'Brazilian Real')),
    ('CZK', _(u'Czech Koruna')),
    ('DKK', _(u'Danish Krone')),
    ('SEK', _(u'Swedish Krona')),
    ('NOK', _(u'Norwegian Krone')),
    ('HUF', _(u'Hungarian Forint')),
    ('ILS', _(u'Israeli Shekel')),
    ('JPY', _(u'Japanese Yen')),
    ('MYR', _(u'Malaysian Ringgit')),
    ('PHP', _(u'Philippine Peso')),
    ('PLN', _(u'Polish Zloty')),
    ('CHF', _(u'Swiss Franc')),
    ('TWD', _(u'Taiwan New Dollar')),
    ('THB', _(u'Thai Baht')),
)

CURRENCY_BY_COUNTRIES = (
    ('AF', 'USD'),
    ('AX', 'EUR'),
    ('AL', 'USD'),
    ('DZ', 'USD'),
    ('AS', 'USD'),
    ('AD', 'EUR'),
    ('AO', 'USD'),
    ('AI', 'USD'),
    ('AQ', 'USD'),
    ('AG', 'USD'),
    ('AR', 'USD'),
    ('AM', 'USD'),
    ('AW', 'USD'),
    ('AU', 'AUD'),
    ('AT', 'EUR'),
    ('AZ', 'USD'),
    ('BS', 'USD'),
    ('BH', 'USD'),
    ('BD', 'USD'),
    ('BB', 'USD'),
    ('BY', 'USD'),
    ('BE', 'EUR'),
    ('BZ', 'USD'),
    ('BJ', 'USD'),
    ('BM', 'USD'),
    ('BT', 'USD'),
    ('BO', 'USD'),
    ('BA', 'USD'),
    ('BW', 'USD'),
    ('BV', 'NOK'),
    ('BR', 'BRL'),
    ('IO', 'USD'),
    ('BN', 'SGD'),
    ('BG', 'USD'),
    ('BF', 'USD'),
    ('BI', 'USD'),
    ('KH', 'USD'),
    ('CM', 'USD'),
    ('CA', 'CAD'),
    ('CV', 'USD'),
    ('KY', 'USD'),
    ('CF', 'USD'),
    ('TD', 'USD'),
    ('CL', 'USD'),
    ('CN', 'USD'),
    ('CX', 'AUD'),
    ('CC', 'AUD'),
    ('CO', 'USD'),
    ('KM', 'USD'),
    ('CG', 'USD'),
    ('CD', 'USD'),
    ('CK', 'NZD'),
    ('CR', 'USD'),
    ('CI', 'USD'),
    ('HR', 'USD'),
    ('CU', 'USD'),
    ('CY', 'EUR'),
    ('CZ', 'CZK'),
    ('DK', 'DKK'),
    ('DJ', 'USD'),
    ('DM', 'USD'),
    ('DO', 'USD'),
    ('EC', 'USD'),
    ('EG', 'USD'),
    ('SV', 'USD'),
    ('GQ', 'USD'),
    ('ER', 'USD'),
    ('EE', 'EUR'),
    ('ET', 'USD'),
    ('FK', 'GBP'),
    ('FO', 'DKK'),
    ('FJ', 'USD'),
    ('FI', 'EUR'),
    ('FR', 'EUR'),
    ('GF', 'EUR'),
    ('PF', 'USD'),
    ('TF', 'EUR'),
    ('GA', 'USD'),
    ('GM', 'USD'),
    ('GE', 'USD'),
    ('DE', 'EUR'),
    ('GH', 'USD'),
    ('GI', 'GBP'),
    ('GR', 'EUR'),
    ('GL', 'DKK'),
    ('GD', 'USD'),
    ('GP', 'EUR'),
    ('GU', 'USD'),
    ('GT', 'USD'),
    ('GG', 'GBP'),
    ('GN', 'USD'),
    ('GW', 'USD'),
    ('GY', 'USD'),
    ('HT', 'USD'),
    ('HM', 'AUD'),
    ('VA', 'EUR'),
    ('HN', 'USD'),
    ('HK', 'HKD'),
    ('HU', 'HUF'),
    ('IS', 'USD'),
    ('IN', 'USD'),
    ('ID', 'USD'),
    ('IR', 'USD'),
    ('IQ', 'USD'),
    ('IE', 'EUR'),
    ('IM', 'GBP'),
    ('IL', 'ILS'),
    ('IT', 'EUR'),
    ('JM', 'USD'),
    ('JP', 'JPY'),
    ('JE', 'GBP'),
    ('JO', 'USD'),
    ('KZ', 'USD'),
    ('KE', 'USD'),
    ('KI', 'AUD'),
    ('KP', 'USD'),
    ('KR', 'USD'),
    ('KW', 'USD'),
    ('KG', 'USD'),
    ('LA', 'USD'),
    ('LV', 'USD'),
    ('LB', 'USD'),
    ('LS', 'USD'),
    ('LR', 'USD'),
    ('LY', 'USD'),
    ('LI', 'CHF'),
    ('LT', 'USD'),
    ('LU', 'EUR'),
    ('MO', 'USD'),
    ('MK', 'USD'),
    ('MG', 'USD'),
    ('MW', 'USD'),
    ('MY', 'MYR'),
    ('MV', 'USD'),
    ('ML', 'USD'),
    ('MT', 'EUR'),
    ('MH', 'USD'),
    ('MQ', 'EUR'),
    ('MR', 'USD'),
    ('MU', 'USD'),
    ('YT', 'EUR'),
    ('MX', 'MXN'),
    ('FM', 'USD'),
    ('MD', 'USD'),
    ('MC', 'EUR'),
    ('MN', 'USD'),
    ('ME', 'EUR'),
    ('MS', 'USD'),
    ('MA', 'USD'),
    ('MZ', 'USD'),
    ('MM', 'USD'),
    ('NA', 'USD'),
    ('NR', 'AUD'),
    ('NP', 'USD'),
    ('NL', 'EUR'),
    ('AN', 'USD'),
    ('NC', 'USD'),
    ('NZ', 'NZD'),
    ('NI', 'USD'),
    ('NE', 'USD'),
    ('NG', 'USD'),
    ('NU', 'NZD'),
    ('NF', 'AUD'),
    ('MP', 'USD'),
    ('NO', 'NOK'),
    ('OM', 'USD'),
    ('PK', 'USD'),
    ('PW', 'USD'),
    ('PS', 'ILS'),
    ('PA', 'USD'),
    ('PG', 'USD'),
    ('PY', 'USD'),
    ('PE', 'USD'),
    ('PH', 'PHP'),
    ('PN', 'NZD'),
    ('PL', 'PLN'),
    ('PT', 'EUR'),
    ('PR', 'USD'),
    ('QA', 'USD'),
    ('RE', 'EUR'),
    ('RO', 'USD'),
    ('RU', 'USD'),
    ('RW', 'USD'),
    ('BL', 'EUR'),
    ('SH', 'GBP'),
    ('KN', 'USD'),
    ('LC', 'USD'),
    ('MF', 'EUR'),
    ('PM', 'EUR'),
    ('VC', 'USD'),
    ('WS', 'USD'),
    ('SM', 'EUR'),
    ('ST', 'USD'),
    ('SA', 'USD'),
    ('SN', 'USD'),
    ('RS', 'USD'),
    ('SC', 'USD'),
    ('SL', 'USD'),
    ('SG', 'SGD'),
    ('SK', 'EUR'),
    ('SI', 'EUR'),
    ('SB', 'USD'),
    ('SO', 'USD'),
    ('ZA', 'USD'),
    ('GS', 'GBP'),
    ('ES', 'EUR'),
    ('LK', 'USD'),
    ('SD', 'USD'),
    ('SR', 'USD'),
    ('SJ', 'NOK'),
    ('SZ', 'USD'),
    ('SE', 'SEK'),
    ('CH', 'CHF'),
    ('SY', 'USD'),
    ('TW', 'TWD'),
    ('TJ', 'USD'),
    ('TZ', 'USD'),
    ('TH', 'THB'),
    ('TL', 'USD'),
    ('TG', 'USD'),
    ('TK', 'NZD'),
    ('TO', 'USD'),
    ('TT', 'USD'),
    ('TN', 'USD'),
    ('TR', 'USD'),
    ('TM', 'USD'),
    ('TC', 'USD'),
    ('TV', 'AUD'),
    ('UG', 'USD'),
    ('UA', 'USD'),
    ('AE', 'USD'),
    ('GB', 'GBP'),
    ('US', 'USD'),
    ('UM', 'USD'),
    ('UY', 'USD'),
    ('UZ', 'USD'),
    ('VU', 'USD'),
    ('VE', 'USD'),
    ('VN', 'USD'),
    ('VG', 'USD'),
    ('VI', 'USD'),
    ('WF', 'USD'),
    ('EH', 'USD'),
    ('YE', 'USD'),
    ('ZM', 'USD'),
    ('ZW', 'USD')
)
