from moderation import RegistrationError


def automoderate(instance, user):
    '''
    Auto moderates given model instance on user. Returns moderation status:
    0 - Rejected
    1 - Approved
    '''
    try:
        status = instance.moderated_object.automoderate(user)
    except AttributeError:
        msg = u"%s has been registered with Moderation." % instance.__class__
        raise RegistrationError(msg)

    return status
