from functools import wraps


from navigator import settings


def navigation_path(path):

    def decorator(func):

        if hasattr(func, settings.NAVIGATOR_PATH_ATTR):
            paths = getattr(func, settings.NAVIGATOR_PATH_ATTR)
            paths.append(path)
        else:
            paths = [path]

        setattr(func, settings.NAVIGATOR_PATH_ATTR, paths)

        @wraps(func)
        def wrapper(request, *args, **kwargs):
            return func(request, *args, **kwargs)
        return wrapper

    return decorator