from six import string_types

from . import settings
from .utils import get_nodes_by_string, get_nodes_by_iter, can_format


class NavigationMiddleware(object):

    def process_view(self, request, view_func, view_args, view_kwargs):

        if not hasattr(request, settings.NAVIGATOR_ATTR):

            if hasattr(view_func, settings.NAVIGATOR_PATH_ATTR):
                paths = getattr(view_func, settings.NAVIGATOR_PATH_ATTR)
                setattr(request, settings.NAVIGATOR_PATH_ATTR,
                        [path.format(*view_args, **view_kwargs) for path in paths
                         if can_format(path, *view_args, **view_kwargs)])

            if settings.NAVIGATOR_EXCLUDE_AJAX_REQUESTS and request.is_ajax():
                return

            navigation_settings = settings.NAVIGATOR_NAVIGATION
            navigation_nodes = {}

            if isinstance(navigation_settings, string_types):
                nodes = get_nodes_by_string(request, navigation_settings)
                navigation_nodes = nodes
            elif isinstance(navigation_settings, dict):
                for key, value in navigation_settings.items():
                    nodes = None
                    if isinstance(value, (tuple, list)):
                        nodes = get_nodes_by_iter(request, value, alias=key)
                    elif isinstance(value, string_types):
                        nodes = get_nodes_by_string(request, value, alias=key)
                    if nodes:
                        navigation_nodes[key] = nodes
            elif isinstance(navigation_settings, (tuple, list)):
                nodes = get_nodes_by_iter(request, navigation_settings)
                navigation_nodes = nodes
            setattr(request, settings.NAVIGATOR_ATTR, navigation_nodes)