from __future__ import absolute_import, unicode_literals

from django.utils.translation import ugettext_lazy as _

try:
    from collections import OrderedDict
except ImportError:
    from django.utils.datastructures import SortedDict as OrderedDict

from debug_toolbar.panels import Panel

from navigator import settings


class NavigatorPanel(Panel):

    template = 'debug_toolbar/panels/navigator.html'

    def title(self):
        return _("Site navigation")

    def process_response(self, request, response):
        navigation = getattr(request, settings.NAVIGATOR_ATTR, {})
        self.record_stats({
            'navigation': navigation
        })
