from __future__ import absolute_import

from django import template
from django.template.loader import render_to_string

from navigator import settings
from navigator import navigation

register = template.Library()


@register.simple_tag
def render_navigation(request, alias, template_key=None, **context):

    if template_key is None:
        template_key = alias

    if template_key in settings.NAVIGATOR_NAVIGATION_TEMPLATES:

        template_name = settings.NAVIGATOR_NAVIGATION_TEMPLATES[template_key]
        nodes = navigation.get_nodes(request, alias)

        context['nodes'] = nodes

        return render_to_string(template_name, context)

    return ''