from six import string_types

from django.core.urlresolvers import resolve
from django.utils.module_loading import import_string

from . import settings


def get_nodes_by_string(request, path, alias=None):
    try:
        navigation_class = import_string(path)
        navigation = navigation_class(request, alias=alias)
        return navigation.get_nodes()
    except (ImportError, AttributeError):
        return


def get_nodes_by_iter(request, path, alias=None):
    try:
        navigation_class_name = path[0]
        apps = path[1]
        valid_apps = []
        if isinstance(apps, string_types):
            valid_apps = [apps]
        elif isinstance(apps, (list, tuple)):
            valid_apps = apps
        if not resolve(request.path).app_name in valid_apps:
            return
        return get_nodes_by_string(request, navigation_class_name, alias=alias)
    except IndexError:
        return


def can_format(target, *args, **kwargs):
    try:
        target.format(*args, **kwargs)
        return True
    except (KeyError, AttributeError):
        return False