import os
from setuptools import setup, find_packages

from github import VERSION

f = open(os.path.join(os.path.dirname(__file__), 'README.rst'))
readme = f.read()
f.close()

setup(
    name='django-news',
    version=".".join(map(str, VERSION)),
    description='rss feed aggregation with django',
    long_description=readme,
    author='Charles Leifer',
    author_email='coleifer@gmail.com',
    url='http://github.com/coleifer/django-news/tree/master',
    packages=find_packages(exclude=['example']),
    package_data = {
        'news': [
            'templates/*.html',
            'templates/*/*.html',
        ],
    },
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Framework :: Django',
    ],
)
