import os
import re

from celery import task,chord,group,chain
from celery.signals import task_success
from celery.utils.log import get_task_logger

from django.conf import settings

from .models import *

@task()
def reset_trigrams():
    files = os.listdir(settings.TRIGRAM_PATH)
    delete_all()
    for f in files:
        load_trigram_file(f)

def delete_all():
    Orthography.objects.all().delete()
    Trigram.objects.all().delete()

def load_trigram_file(f):
    trgs = []
    with open(os.path.join(settings.TRIGRAM_PATH,f),'r') as file_handle:
        for line in file_handle:
            l = line.strip().split("\t")
            words = []
            for w in l[0].split(" "):
                words.append(Orthography.objects.get_or_create(spelling=w)[0])
            trgs.append(Trigram(word=words[-1],word_i_minus_one=words[1],word_i_minus_two=words[0],count=int(l[1])))
            if len(trgs) > 100000:
                Trigram.objects.bulk_create(trgs)
                trgs = []
    if trgs != []:
        Trigram.objects.bulk_create(trgs)
