import os
import re

from celery import task,chord,group,chain
from celery.signals import task_success
from celery.utils.log import get_task_logger

from django.conf import settings

from .models import *

@task()
def reset_trigrams():
    files = sorted(os.listdir(settings.TRIGRAM_PATH))
    c2 = (delete_all.si() | load_trigrams.si(files))
    res = c2()
    res.get()


@task()
def delete_all():
    Trigram.objects.all().delete()


@task()
def load_trigrams(files):
    for f in files:
        print f
        load_trigram_file(f)


def load_trigram_file(f):
    trgs = []
    with open(os.path.join(settings.TRIGRAM_PATH,f),'r') as file_handle:
        for line in file_handle:
            l = line.strip().split("\t")
            words = l[0].split(" ")
            ws = Orthography.objects.filter(spelling__in = words)
            for i in range(len(words)):
                for s in ws:
                    if words[i] == s.spelling:
                        words[i] = s
                        break
            trgs.append(Trigram(word=words[-1],word_i_minus_one=words[1],word_i_minus_two=words[0],count=int(l[1])))
            if len(trgs) > 100000:
                Trigram.objects.bulk_create(trgs)
                trgs = []
    if trgs != []:
        Trigram.objects.bulk_create(trgs)
