# -*- coding: utf-8 -*-
"""
Cache and transform header middleware
"""


class NPNoTransformMiddleware:
    """
    Prevent people like o2 UK mangling your responses through their
    proxies by sending a no-transform header with every response
    """

    def process_response(self, request, response):
        """
        Send a cache-control header with no-transform as the value

        :param request: Django request object
        :type request: HttpRequest
        :param response: Django response object
        :type response: HttpResponse
        :return: Response object with added P3P header
        :rtype: HttpResponse
        """

        response['Cache-Control'] = 'no-transform'

        return response


class NPNoCacheNoTransformMiddleware:
    """
    Prevent caching and HTTP transforms by sending appropriate headers

    This is probably a rarely used thing, some enterprise stuff I did
    requested that nothing generated by django was ever cached, and o2
    uk kept mangling up rendered js and suchlike, so its here in the
    hope that someone might find it useful
    """

    def process_response(self, request, response):
        """
        Send cache-control and pragma headers with no-transform and no
        caching stuffs

        :param request: Django request object
        :type request: HttpRequest
        :param response: Django response object
        :type response: HttpResponse
        :return: Response object with added P3P header
        :rtype: HttpResponse
        """

        response['Cache-Control'] = 'private, no-cache, no-store, ' \
                                    'proxy-revalidate, no-transform'
        response['Pragma'] = 'no-cache'

        return response