#!/usr/bin/env python
# vim: set fileencoding=utf8:
"""
Mini blog forms


AUTHOR:
    lambdalisue[Ali su ae] (lambdalisue@hashnote.net)
    
Copyright:
    Copyright 2011 Alisue allright reserved.

License:
    Licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unliss required by applicable law or agreed to in writing, software
    distributed under the License is distrubuted on an "AS IS" BASICS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""
__AUTHOR__ = "lambdalisue (lambdalisue@hashnote.net)"
from django import forms

from models import Entry

class EntryForm(forms.ModelForm):
    class Meta:
        model = Entry
        fields = ('title', 'body')

    def __init__(self, request, *args, **kwargs):
        self.request = request
        super(EntryForm, self).__init__(*args, **kwargs)

    def save(self, commit=True):
        self.instance.author = self.request.user
        return super(EntryForm, self).save(commit)
