/*!
 * Django-Omnibus
 * Django/JavaScript WebSocket Connections
 *
 * @version 0.0.1
 * @author Moccu GmbH & Co. KG, Kreativagentur für digitale Medien <http://www.moccu.com/>
 * @author Stephan Jaekel <https://github.com/stephrdev>
 * @author Norman Rusch <https://github.com/schorfES>
 */
!function(a,b){"function"==typeof define&&define.amd?define(b):"object"==typeof exports?module.exports=b():a.Omnibus=b()}(this,function(){function a(){var a,b,c=Array.prototype.shift.call(arguments);if("object"==typeof c&&arguments.length>0)for(;arguments.length>0;)if(a=Array.prototype.shift.call(arguments))for(b in a)c[b]=a[b];return c}function b(a,b){return function(){"function"==typeof a&&a.apply(b,arguments)}}var c={INDICATOR:"!",DELIMITER:":",AUTHENTICATE:"authenticate",SUBSCRIBE:"subscribe",UNSUBSCRIBE:"unsubscribe"},d=function(a,b,c){this.sender=a,this.name=b,this.data=c},e=function(){this._events={}};a(e.prototype,{on:function(a,b){return this._events[a]||(this._events[a]=[]),this._events[a].push(b),this},off:function(a,b){var c;if(void 0===a)for(c in this._events)this._events[c]=void 0,delete this._events[c];else if("object"==typeof this._events[a])if("function"==typeof b)for(c=0;c<this._events[a].length;c++)this._events[a][c]===b&&this._events[a].splice(c,1);else this._events[a]=void 0,delete this._events[a];return this},trigger:function(a,b){return this._trigger(a,b),"*"!==a&&this._trigger("*",b,a),this},_trigger:function(a,b,c){var e,f=new d(this,c||a,b);if("object"==typeof this._events[a])for(e=0;e<this._events[a].length;e++)this._events[a][e](f)}});var f={CHANNEL_SUBSCRIBED:"subscribed",CHANNEL_UNSUBSCRIBED:"unsubscribed",CHANNEL_CLOSE:"close",CHANNEL_DESTROY:"destroy",CONNECTION_CONNECTED:"connected",CONNECTION_DISCONNECTED:"disconnected",CONNECTION_AUTHENTICATED:"authenticated",CONNECTION_ERROR:"error"},g=function(a,b){e.call(this),this._closed=!0,this._subscribed=!1,this._name=a,this._connection=b,this._subscribe()};a(g.prototype,e.prototype,{_subscribe:function(){this.isSubscribed()||this._connection.sendCommandMessage(c.SUBSCRIBE,this._name)},getName:function(){return this._name},isSubscribed:function(){return this._subscribed||!1},_handleSubscribed:function(){this._subscribed||(this._closed=!1,this._subscribed=!0,this.trigger(f.CHANNEL_SUBSCRIBED))},_handleUnsubscribed:function(){this._subscribed&&(this._subscribed=!1,this.trigger(f.CHANNEL_UNSUBSCRIBED))},send:function(a,b){return this._subscribed?this._connection.sendChannelMessage(this._name,a,b):!1},close:function(){this.isDestroyed()||this._closed||this._connection.closeChannel(this)},_handleClose:function(){return this.isDestroyed()||this._closed?!1:(this._closed=!0,this.trigger(f.CHANNEL_CLOSE),!0)},_destroy:function(){return this.isDestroyed()?!1:(this._destroyCalledBefore=!0,this.trigger(f.CHANNEL_DESTROY),this._name=void 0,this._subscribed=void 0,this._connection=void 0,this.off(),delete this._name,delete this._subscribed,delete this._connection,!0)},isDestroyed:function(){return this._destroyCalledBefore||!1}});var h,i={ignoreSender:!0,debug:!1,autoReconnect:!0,autoReconnectTimeout:500};return h=function(b,c,d){e.call(this),this._socketOpen=!1,this._authenticated=!1,this._identifier=this._getUid(),this._transport=b,this._remote=c,this._options=a({},i,d),this._channels={},this._sendQueue=[],this._initializeConnection()},a(h.prototype,e.prototype,{_getUid:function(a){return a?(a^16*Math.random()>>a/4).toString(16):"10000000-1000-4000-8000-100000000000".replace(/[018]/g,this._getUid)},_log:function(a,b){this._options.debug&&window&&window.console&&"function"==typeof window.console.log&&window.console.log("["+(new Date).toISOString()+"|"+a+"] ",b)},_initializeConnection:function(){if(!(this._transport instanceof Object))throw new Error("Provide a Websocket API as constructor argument.");if(this._socket)throw new Error("Connection already initialized.");this._log("info","Connecting"),this._socket=new this._transport(this._remote),this._socket.onopen=b(this._onSocketOpen,this),this._socket.onclose=b(this._onSocketClose,this),this._socket.onmessage=b(this._onSocketMessage,this),this._socket.onerror=b(this._onSocketError,this)},getId:function(){return this._identifier},isConnected:function(){return this._socketOpen},isAuthenticated:function(){return this._authenticated},openChannel:function(a){return this.getChannel(a)||this._createChannel(a)},_createChannel:function(a){if("string"!=typeof a||0===a.length)throw new Error("Channel name must be a valid String.");if(a.indexOf(c.DELIMITER)>-1||a.indexOf(c.INDICATOR)>-1)throw new Error("Channel name contains invalid characters.");var b=new g(a,this);return this._channels[a]=b,b},closeChannel:function(a){var b=!1,d=a;if("string"!=typeof a&&!(d instanceof g))throw new Error("To close channel provide channel instance or channel name.");return"string"==typeof a&&(d=this.getChannel(a)),d instanceof g&&(b=d._handleClose(),this.sendCommandMessage(c.UNSUBSCRIBE,d.getName())),b},_removeChannel:function(a){"string"==typeof a&&this._channels[a]instanceof g&&(this._channels[a]._destroy(),this._channels[a]=null,delete this._channels[a])},getChannel:function(a){return this._channels[a]},sendCommandMessage:function(a,b,d){return this._send(c.INDICATOR+a+c.DELIMITER+b,d)},sendChannelMessage:function(a,b,d,e){var f=JSON.stringify({type:b,sender:this._identifier,payload:d});return this._send(a+c.DELIMITER+f,e)},_send:function(a,b){return this._log("debug","Out: "+a),this._socket&&this.isConnected()&&(this.isAuthenticated()||b)?this._socket.send(a):this._sendQueue.push(a),!!this._socket},_flushQueue:function(){for(;this._sendQueue.length>0;)this._send(this._sendQueue.shift())},_handleCommandMessage:function(a,b){switch(a){case c.AUTHENTICATE:this._handleCommandAuthenticate(b);break;case c.SUBSCRIBE:this._handleCommandSubscribe(b);break;case c.UNSUBSCRIBE:this._handleCommandUnsubscribe(b)}},_handleCommandAuthenticate:function(a){a.success&&(this._authenticated=!0,this.trigger(f.CONNECTION_AUTHENTICATED),this._flushQueue())},_handleCommandSubscribe:function(a){if(a.success&&"string"==typeof a.payload.channel){var b=this.getChannel(a.payload.channel);b&&b._handleSubscribed(a)}},_handleCommandUnsubscribe:function(a){if(a.success&&"string"==typeof a.payload.channel){var b=this.getChannel(a.payload.channel);b&&(b._handleUnsubscribed(a),this._removeChannel(b.getName()))}},_handleChannelMessage:function(a,b){if(!this._options.ignoreSender||b.sender!==this._identifier){var c=this.getChannel(a);c&&c.trigger(b.type,b)}},_handleReconnect:function(){var a,b;this._initializeConnection();for(b in this._channels)a=this._channels[b],a._subscribe()},_onSocketOpen:function(){this._log("info","Connected"),this._socketOpen=!0;var a=this._identifier;this._options.authToken&&(a=a+c.DELIMITER+this._options.authToken),this.trigger(f.CONNECTION_CONNECTED),this.sendCommandMessage(c.AUTHENTICATE,a,!0)},_onSocketClose:function(){var a,c;this._log("info","Disconnected"),this._socket=null,this._socketOpen=!1,this._authenticated=!1,this.trigger(f.CONNECTION_DISCONNECTED);for(c in this._channels)a=this._channels[c],a._handleUnsubscribed();this._options.autoReconnect&&window.setTimeout(b(this._handleReconnect,this),this._options.autoReconnectTimeout)},_onSocketMessage:function(a){this._log("debug","In: "+a.data);var b=a.data,d=b.indexOf(c.DELIMITER),e=b.substring(0,d),f=JSON.parse(b.substring(d+1));0===e.indexOf(c.INDICATOR)?(e=e.substr(1),this._handleCommandMessage(e,f)):this._handleChannelMessage(e,f)},_onSocketError:function(a){this.trigger(f.CONNECTION_ERROR,a)}}),h.events=a({},f),h.defaults=a({},i),h});