import os
from setuptools import setup, find_packages
import online_docs


def read(fname):
    try:
        return open(os.path.join(os.path.dirname(__file__), fname)).read()
    except IOError:
        return ''


setup(
    name="django-online-docs",
    version=online_docs.__version__,
    description=read('DESCRIPTION'),
    long_description=read('README.rst'),
    license='The MIT License',
    platforms=['OS Independent'],
    keywords='django, docs, documentation, interactive, ajax',
    author='Martin Brochhaus',
    author_email='mbrochh@gmail.com',
    url="https://github.com/bitmazk/django-online-docs",
    packages=find_packages(),
    include_package_data=True,
    install_requires=[
        'Django',
        'markdown',
    ],
    tests_require=[
        'fabric',
        'factory_boy',
        'django-nose',
        'coverage',
        'django-coverage',
        'mock',
        'selenium',
    ],
    test_suite='online_docs.tests.runtests.runtests',
)
