from django.core.exceptions import ObjectDoesNotExist

def acquire_reference(reference):
    try:
        implementation, identifier = reference.split(':')
        module, sep, attr = implementation.rpartition('.')
        implementation = getattr(__import__(module, fromlist=(attr,)), attr)
        return implementation.objects.get(pk=identifier)
    except ObjectDoesNotExist:
        return None
    except Exception:
        raise ValueError

def identify_instance(instance):
    implementation = type(instance)
    return '%s.%s:%s' % (implementation.__module__, implementation.__name__, instance.pk)

def serialize_references(references):
    refs = {}
    for key, instance in references.iteritems():
        if not isinstance(instance, basestring):
            refs[key] = identify_instance(instance)
        else:
            refs[key] = instance
    else:
        return refs

def unserialize_references(references):
    refs = {}
    for key, reference in references.iteritems():
        if isinstance(reference, basestring):
            refs[key] = acquire_reference(reference)
        else:
            refs[key] = reference
    else:
        return refs
