Django-pages
===========================

About this project
------------------

This project will give you the power of standard CMS (content management system) like Drupal, Joomla, WordPress but with much more speed and simplicity.

It may not have as much plugins and templates like WordPress but it is super simple application with django admin with WYSIWYG editors for page and post editing.

It is designed for easy web content editing with no previous experience in HTML or CSS. Just install it once, use default template or create one for yourself (or hire someone to make it) and use it. There is no maintenance required.

This project is running on this site: [Nemec.lu](http://nemec.lu/)

Installation
------------

Note: do NOT use settings.py from this project! the secret key is visible to all and it is a security risk. Create your own Django application and simply fill settings depending on your configuration.

Get this application:

    Clone from git or download zip with sources

Create your project:

    Install Django (pip install django)
    Create your Django application (see [django docs](https://docs.djangoproject.com/en/1.5/intro/install/))

Install dependencies:
    
    pip install -r DEPENDENCIES

Configure:

    add INSTALLED_APPS to your settings.py according to settings.py
    fill your settings.py for your usage

Create empty database:
    
    run #~ python manage.py syncdb  to create database and tables
    
Run webserver:
    
    run your webserver (nginx/apache/django test server)

Add some nice website content:

    go to http://your_site/admin/ and create structure

    Use your new webpage!


Configuration
-------------

Note: the 2 steps below may be skipped by using default files that come with this project, BUT MAKE SURE TO FOOLOW THESE STEPS:
    
    Set your database connection
    REPLACE SECRET_KEY in settings.py (google for django secret key generator)
    Run # python manage.py syncdb (in your project dir), and follow instructions (yes on creating admin account)
    Set Nginx (preferably) or Apache or any Http server (manual on nginx setup is on http://lnemec.tk)

    Optional:
        Set DEBUG = True in settings.py while creating pages to see debugging information

Update your settings.py

    Read django basic install https://docs.djangoproject.com/en/1.5/intro/install/ and set your database connection

    Set TIME_ZONE to your country
    Set MEDIA_ROOT, STATIC_ROOT, (STATICFILED_DIRS only with django webserver in testing enviroment)
    Set TEMPLATE_DIRS to path where you installed this application

    Be sure to include grappelli, django.contrib.admin, django.contrib.admindocs, wysiwyg.wysiwyg in INSTALLED_APPS

    Copy all lines below # CUSTOM WYSIWYG settings to your settings.py

Update your urls.py

    Add url(r'^admin/doc/', include('django.contrib.admindocs.urls'))
    Add url(r'^admin/', include(admin.site.urls))
    Add url(r'^grappelli/', include('grappelli.urls'))
    Add url(r'^(?P<url>.*)$', 'wysiwyg.wysiwyg.views.main_view') # MUST be LAST item


Create website
--------------

**Or use the new Wizzard (go to http://yoururl.example/wizzard/)**

    Go to http://mydomain.example/admin/ (replace mydomain.example with your actual domain)
    
    Login using credentials from command python manage.py syncdb

    Create Site

    Create Language(s)

    Create Menu for Languages

    Create MenuItems with good url (for SEO) for Menu # example: my-page-that-displays-how-to-cook

    Create exactly 1 Page with index set to True

    Create Pages with content pointing to MenuItems which create link to that Page

    Set Language, Page and others as Active to be displayed

    Create 1 Feed Setting, either with information or just deactivated feed (RSS and Atom feed setting)

    Optional:
    Create Posts on Page (optional: set duration for Post visibility)

    SEO:
    Create MetaSets for Pages
    Create MetaData for MetaSets

    Set DEBUG = False in you settings.py after succesfull creation!

    Done!


Wizzard
-------

This is just a simple helper page, that will guide you through the process of creating your presentation.
Images and exmplanations included.

Wizzard is accesible from http://yoursite.com/wizzard/


Adding Images
-------------

You can now add images directly from admin. Select Page/Post you want to edit. Click on Image icon in the editor.
Click Browse server. In the new window, either upload your image (will be automatically resized to fit 800x600 px) or select
already uploaded image from the files.

Once selected, Image will be automatically selected by the editor, and you can hit OK.
It will automatically create link for that image.

If you want this image to have nice pop-up effects from Lightbox2, click on small magnifiing glass icon (Create Lightbox),
insert text you want the image to have and click OK.

Files will be uploaded to your MEDIA_ROOT path into folder uploaded (you can change this in file connector/settings.oy)

Don't forget to set your /media/uploadeded/ folder permissions to 775 so you'll be able to save images into it from admin!


Scheme
------

Wysiwyg editor uses this application and database scheme

    Site
    Language --> 
        Menu for that language --> 
            {Multiple menuitems} --> 
                [Page for each menuitem] --> 
                    (Multiple Posts for each Page - with pagination) -->
                        (Multiple comments for each Post)
                [MetaSet for each page] -->
                    (Multiple MetaData for each MetaSet)

Url
---

Url is following:

    http://mydomain.example/language/my-page-with-somethin~page_number/~post
    
Rules are following:

    language - string with 2-3 letters
    page - 4-200 letters where allowed is alphabet, digits and - . _
    page_number - digits
    post - same as page

Note: all of this is generated automatically from DB, you provide country_code for your language
which is used as /language part of url. MenuItem url is used as Page url part. Page_number is determined
automatically from post count. Post detail url is determined automatically from post title - alphabet lowercase
with rules same as page.

Reserved URLs:
    
    /admin/*
    /connector/*
    /grapelli/*
    /wizzard/
    /rss/
    /atom/
    /robots.txt
    /sitemap.xml


Caching
-------

Wysiwyg now supports caching in-memory (I guess), for some reason django's wrapper @chache_page for specific view caching works without CACHE in settings.py, which is weird at least. And I tried memcached, in-memory and without cache, and in-memory had the best results, and you don't even have to configure it.
Now it can handle 50 concurrent page acceses in 12ms! (tested with ab -n 1000 -c 50 http://lnemec.tk/)


Atom and RSS
------------

Atom and RSS are accessible under /atom/ and /rss/ respectively.
Simply add one record into admin Feed Settings, it must contain Site Title, Site Description, and latest post count.
You can disable rss and atom feed by disabling it in admin.
Any new Posts under any menu/menuitem will be shown in rss/atom feed from newest to oldest.


Changelog
---------

- 22.5.2013 - added wizzard for first run
- 21.5.2013 - added nice image uploading and selecting from wysiwyg
- 3.5.2013 - added RSS and Atom feed support
- 2.5.2013 - added Google+ and Facebook like to post detail page
