# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CustomPaymentConfig',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateField()),
                ('amount', models.PositiveIntegerField()),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='MultiPaymentConfig',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('first', models.PositiveIntegerField()),
                ('count', models.PositiveIntegerField()),
                ('period', models.PositiveIntegerField()),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='PaymentRequest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('vads_cust_address', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_cust_address_number', models.CharField(max_length=5, null=True, blank=True)),
                ('vads_cust_country', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_cust_email', models.EmailField(max_length=75, null=True, blank=True)),
                ('vads_cust_id', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_name', models.CharField(max_length=127, null=True, blank=True)),
                ('vads_cust_last_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_first_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_cell_phone', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_cust_phone', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_cust_title', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_city', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_status', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_state', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_zip', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_language', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_order_id', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_order_info', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_order_info2', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_order_info3', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ship_to_name', models.CharField(max_length=127, null=True, blank=True)),
                ('vads_ship_to_first_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_last_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_street_number', models.CharField(max_length=5, null=True, blank=True)),
                ('vads_ship_to_street', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ship_to_street2', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ship_to_zip', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_city', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_country', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_ship_to_phone_num', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_ship_to_state', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_action_mode', models.CharField(default=b'INTERACTIVE', max_length=11, choices=[(b'INTERACTIVE', b'INTERACTIVE'), (b'SILENT', b'SILENT')])),
                ('vads_amount', models.PositiveIntegerField()),
                ('vads_currency', models.CharField(default=b'978', max_length=3, choices=[(b'036', b'Australian dollar'), (b'124', b'Canadian dollar'), (b'156', b'Chinese Yuan'), (b'208', b'Danish Krone'), (b'392', b'Japanese Yen'), (b'578', b'Norwegian Krone'), (b'752', b'Swedish Krona'), (b'756', b'Swiss franc'), (b'826', b'Pound sterling'), (b'840', b'American dollar'), (b'953', b'Franc Pacifique (CFP)'), (b'978', b'Euro')])),
                ('vads_ctx_mode', models.CharField(default=b'TEST', max_length=10, choices=[(b'TEST', b'TEST'), (b'PRODUCTION', b'PRODUCTION')])),
                ('vads_page_action', models.CharField(default=b'PAYMENT', max_length=7)),
                ('vads_payment_config', models.TextField()),
                ('vads_site_id', models.PositiveIntegerField(default=b'29822824')),
                ('vads_trans_date', models.CharField(max_length=14)),
                ('vads_trans_id', models.CharField(max_length=6)),
                ('vads_version', models.CharField(default=b'V2', max_length=2)),
                ('signature', models.CharField(max_length=40)),
                ('vads_capture_delay', models.PositiveIntegerField(null=True, blank=True)),
                ('vads_contrib', models.CharField(default=b'django-payzen v0.9', max_length=255, null=True, blank=True)),
                ('vads_payment_cards', models.CharField(max_length=127, null=True, blank=True)),
                ('vads_return_mode', models.CharField(blank=True, max_length=12, null=True, choices=[(b'AMEX', b'American Express'), (b'AURORE-MULTI', b'AURORE (multi brand)'), (b'BUYSTER', b'BUYSTER'), (b'CB', b'CB'), (b'COFINOGA', b'COFINOGA'), (b'E-CARTEBLEUE', b'e blue card'), (b'MASTERCARD', b'Eurocard / MasterCard'), (b'JCB', b'JCB'), (b'MAESTRO', b'Maestro'), (b'ONEY', b'ONEY'), (b'ONEY_SANDBOX', b'ONEY SANDBOX mode'), (b'PAYPAL', b'PAYPAL'), (b'PAYPAL_SB', b'PAYPAL SANDBOX mode'), (b'PAYSAFECARD', b'PAYSAFECARD'), (b'VISA', b'Visa'), (b'VISA_ELECTRON', b'Visa Electron'), (b'COF3XCB', b'3x CB Cofinoga'), (b'COF3XCB_SB', b'3x CB Cofinoga SANDBOX')])),
                ('vads_theme_config', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_validation_mode', models.CharField(blank=True, max_length=1, null=True, choices=[(b'', b'Default shop configuration (using payzen admin)'), (b'0', b'Automatic validation'), (b'1', b'Manual validation')])),
                ('vads_url_success', models.URLField(null=True, blank=True)),
                ('vads_url_referral', models.URLField(null=True, blank=True)),
                ('vads_url_refused', models.URLField(null=True, blank=True)),
                ('vads_url_cancel', models.URLField(null=True, blank=True)),
                ('vads_url_error', models.URLField(null=True, blank=True)),
                ('vads_url_return', models.URLField(null=True, blank=True)),
                ('vads_user_info', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_shop_name', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_redirect_success_timeout', models.PositiveIntegerField(null=True, blank=True)),
                ('vads_redirect_success_message', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_redirect_error_timeout', models.PositiveIntegerField(null=True, blank=True)),
                ('vads_redirect_error_message', models.CharField(max_length=255, null=True, blank=True)),
                ('custom_payment_config', models.ManyToManyField(to='django_payzen.CustomPaymentConfig')),
                ('payment_config', models.ForeignKey(blank=True, to='django_payzen.MultiPaymentConfig', null=True)),
            ],
            options={
                'verbose_name': 'Request',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='PaymentResponse',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('vads_cust_address', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_cust_address_number', models.CharField(max_length=5, null=True, blank=True)),
                ('vads_cust_country', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_cust_email', models.EmailField(max_length=75, null=True, blank=True)),
                ('vads_cust_id', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_name', models.CharField(max_length=127, null=True, blank=True)),
                ('vads_cust_last_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_first_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_cell_phone', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_cust_phone', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_cust_title', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_city', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_status', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_state', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_cust_zip', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_language', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_order_id', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_order_info', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_order_info2', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_order_info3', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ship_to_name', models.CharField(max_length=127, null=True, blank=True)),
                ('vads_ship_to_first_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_last_name', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_street_number', models.CharField(max_length=5, null=True, blank=True)),
                ('vads_ship_to_street', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ship_to_street2', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ship_to_zip', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_city', models.CharField(max_length=63, null=True, blank=True)),
                ('vads_ship_to_country', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_ship_to_phone_num', models.CharField(max_length=32, null=True, blank=True)),
                ('vads_ship_to_state', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_threeds_enrolled', models.CharField(blank=True, max_length=1, null=True, choices=[(b'Y', b'Y'), (b'N', b'N'), (b'U', b'U')])),
                ('vads_threeds_cavv', models.CharField(max_length=28, null=True, blank=True)),
                ('vads_threeds_eci', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_threeds_xid', models.CharField(max_length=28, null=True, blank=True)),
                ('vads_threeds_cavvAlgorithm', models.CharField(blank=True, max_length=1, null=True, choices=[(b'0', b'HMAC'), (b'1', b'CVV'), (b'2', b'CVV_ATN'), (b'3', b'Mastercard SPA')])),
                ('vads_threeds_status', models.CharField(blank=True, max_length=1, null=True, choices=[(b'Y', b'U'), (b'N', b'N'), (b'U', b'U'), (b'A', b'A')])),
                ('vads_threeds_sign_valid', models.NullBooleanField()),
                ('vads_threeds_error_code', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_threeds_exit_status', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_warranty_result', models.CharField(max_length=13, null=True, blank=True)),
                ('vads_available_languages', models.TextField(null=True, blank=True)),
                ('vads_theme_config', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_shop_url', models.URLField(null=True, blank=True)),
                ('vads_shop_name', models.CharField(max_length=255, null=True, blank=True)),
                ('signature', models.CharField(max_length=40)),
                ('vads_ctx_mode', models.CharField(max_length=10, choices=[(b'TEST', b'TEST'), (b'PRODUCTION', b'PRODUCTION')])),
                ('vads_url_check_src', models.CharField(max_length=10, choices=[(b'PAY', b'PAY'), (b'BO', b'BO'), (b'BATCH_AUTO', b'BATCH_AUTO'), (b'FILE', b'FILE'), (b'REC', b'REC'), (b'MERCH_BO', b'MERCH_BO')])),
                ('vads_version', models.CharField(max_length=2)),
                ('vads_trans_date', models.CharField(max_length=14)),
                ('vads_action_mode', models.CharField(max_length=11, choices=[(b'INTERACTIVE', b'INTERACTIVE'), (b'SILENT', b'SILENT')])),
                ('vads_trans_id', models.CharField(max_length=6)),
                ('vads_payment_config', models.TextField(null=True, blank=True)),
                ('vads_sequence_number', models.PositiveSmallIntegerField(null=True, blank=True)),
                ('vads_site_id', models.PositiveIntegerField()),
                ('vads_amount', models.PositiveIntegerField(null=True, blank=True)),
                ('vads_currency', models.CharField(blank=True, max_length=3, null=True, choices=[(b'036', b'Australian dollar'), (b'124', b'Canadian dollar'), (b'156', b'Chinese Yuan'), (b'208', b'Danish Krone'), (b'392', b'Japanese Yen'), (b'578', b'Norwegian Krone'), (b'752', b'Swedish Krona'), (b'756', b'Swiss franc'), (b'826', b'Pound sterling'), (b'840', b'American dollar'), (b'953', b'Franc Pacifique (CFP)'), (b'978', b'Euro')])),
                ('vads_effective_amount', models.PositiveIntegerField(null=True, blank=True)),
                ('vads_operation_type', models.CharField(blank=True, max_length=6, null=True, choices=[(b'DEBIT', b'DEBIT'), (b'CREDIT', b'CREDIT')])),
                ('vads_result', models.CharField(max_length=2, choices=[(b'00', b'Payment successful'), (b'02', b'Merchant should contact his bank'), (b'05', b'Payment refused'), (b'30', b'Wrong request format'), (b'96', b'Technical error during payment process')])),
                ('vads_validation_mode', models.CharField(blank=True, max_length=1, null=True, choices=[(b'', b'Default shop configuration (using payzen admin)'), (b'0', b'Automatic validation'), (b'1', b'Manual validation')])),
                ('vads_trans_status', models.CharField(max_length=33, choices=[(b'ABANDONED', b'ABANDONED'), (b'AUTHORISED', b'AUTHORISED'), (b'REFUSED', b'REFUSED'), (b'AUTHORISED_TO_VALIDATE', b'AUTHORISED_TO_VALIDATE'), (b'WAITING_AUTHORISATION', b'WAITING_AUTHORISATION'), (b'EXPIRED', b'EXPIRED'), (b'CANCELLED', b'CANCELLED'), (b'WAITING_AUTHORISATION_TO_VALIDATE', b'WAITING_AUTHORISATION_TO_VALIDATE'), (b'CAPTURED', b'CAPTURED')])),
                ('vads_effective_creation_date', models.CharField(max_length=14, null=True, blank=True)),
                ('vads_presentation_date', models.CharField(max_length=14, null=True, blank=True)),
                ('vads_capture_delay', models.PositiveIntegerField(null=True, blank=True)),
                ('vads_card_brand', models.CharField(max_length=50, null=True, blank=True)),
                ('vads_card_number', models.CharField(max_length=16, null=True, blank=True)),
                ('vads_expiry_month', models.PositiveSmallIntegerField(null=True, blank=True)),
                ('vads_expiry_year', models.PositiveSmallIntegerField(null=True, blank=True)),
                ('vads_contract_used', models.CharField(max_length=250)),
                ('vads_auth_number', models.CharField(max_length=6, null=True, blank=True)),
                ('vads_auth_result', models.CharField(max_length=2, null=True, blank=True)),
                ('vads_auth_mode', models.CharField(blank=True, max_length=4, null=True, choices=[(b'FULL', b'FULL'), (b'MARK', b'MARK')])),
                ('vads_payment_certificate', models.CharField(max_length=40, null=True, blank=True)),
                ('vads_payment_src', models.CharField(blank=True, max_length=5, null=True, choices=[(b'EC', b'EC'), (b'MOTO', b'MOTO'), (b'CC', b'CC'), (b'OTHER', b'OTHER')])),
                ('vads_contrib', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_user_info', models.CharField(max_length=255, null=True, blank=True)),
                ('vads_ext_trans_id', models.CharField(max_length=6, null=True, blank=True)),
                ('vads_payment_option_code', models.TextField(null=True, blank=True)),
                ('vads_change_rate', models.TextField(null=True, blank=True)),
            ],
            options={
                'verbose_name': 'Response',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='ThemeConfig',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('success_footer_msg_return', models.TextField(null=True, blank=True)),
                ('cancel_footer_msg_return', models.TextField(null=True, blank=True)),
                ('secure_message', models.TextField(null=True, blank=True)),
                ('secure_message_register', models.TextField(null=True, blank=True)),
                ('site_id_label', models.TextField(null=True, blank=True)),
                ('css_for_payment', models.URLField(null=True, blank=True)),
                ('css_for_payment_mobile', models.URLField(null=True, blank=True)),
                ('header_for_mail', models.URLField(null=True, blank=True)),
                ('footer_for_mail', models.URLField(null=True, blank=True)),
                ('shop_logo', models.URLField(null=True, blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='VADContract',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('cb_contract_num', models.CharField(max_length=32)),
                ('amex_contract_num', models.CharField(max_length=32)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='paymentresponse',
            unique_together=set([('vads_trans_id', 'vads_site_id', 'vads_trans_date')]),
        ),
        migrations.AddField(
            model_name='paymentrequest',
            name='theme',
            field=models.ForeignKey(blank=True, to='django_payzen.ThemeConfig', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='paymentrequest',
            name='user',
            field=models.ForeignKey(blank=True, to=settings.AUTH_USER_MODEL, null=True),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='paymentrequest',
            unique_together=set([('vads_trans_id', 'vads_site_id', 'vads_trans_date')]),
        ),
    ]
