# vim: set fileencoding=utf-8 :
from setuptools import setup, find_packages

version = '0.2.1'

def read(filename):
    import os.path
    return open(os.path.join(os.path.dirname(__file__), filename)).read()

setup(
    name="django-permission",
    version=version,
    description = "A enhanced permission system which enable object permission",
    long_description=read('README.rst'),
    classifiers = [
        # http://pypi.python.org/pypi?%3Aaction=list_classifiers
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP',

    ],
    keywords = "django permisssion auth",
    author = "Alisue",
    author_email = "lambdalisue@hashnote.net",
    url=r"https://github.com/lambdalisue/django-permission",
    download_url = r"https://github.com/lambdalisue/django-permission/tarball/master",
    license = 'MIT',
    packages = find_packages(exclude=['tests']),
    include_package_data = True,
    zip_safe=False,
    install_requires=[
        'distribute',
        'setuptools-git',
        'django>=1.3',
        'django-mptt',
    ],
    test_suite='runtests.runtests',
    tests_require=[
        'PyYAML',
    ],
)
