#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys


try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

if sys.argv[-1] == 'publish':
    os.system('python setup.py sdist upload')
    sys.exit()

readme = open('README.rst').read()
history = open('HISTORY.rst').read().replace('.. :changelog:', '')

requirements = [
    'fitbit>=0.0.2', 'django-cron>=0.3.2', 'django-tastypie>=0.10.0'
]

setup(
    name='django-phitbit',
    version='0.1.0',
    description='An alternative implementation of the Fitbit API for Django.',
    long_description=readme + '\n\n' + history,
    author='Paul Hallett',
    author_email='hello@phalt.co',
    url='https://github.com/phalt/django-phitbit',
    packages=[
        'django_phitbit',
    ],
    package_dir={'django_phitbit': 'django_phitbit'},
    include_package_data=True,
    install_requires=requirements,
    license="BSD",
    zip_safe=False,
    keywords='django-phitbit',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        "Programming Language :: Python :: 2",
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
    ],
    test_suite='tests',
)
