#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django.contrib import messages
from functools import wraps
from . import utils


def phitbit_authenticated(msg=utils.defaults['PHITBIT_AUTH_MESSAGE']):
    """ Require Fitbit authentication to access the view

    This decorator checks the request.user.phitbit._authenticated
    method.

    """
    def inner_decorator(view_func):
        def wrapped(request, *args, **kwargs):
            user = request.user
            if not user.phitbit._authenticated():
                text = msg(request) if callable(msg) else msg
                messages.error(request, text)
            return view_func(request, *args, **kwargs)
        return wraps(view_func)(wrapped)
    return inner_decorator
