#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django.conf import settings
from django.core.exceptions import ImproperlyConfigured

PHITBIT_ERROR_REDIRECT = ('/')
PHITBIT_SUCCESS_REDIRECT = ('/')
PHITBIT_AUTH_MESSAGE = ("""
    Fitbit authentication is required. Please login to Fitibit. """)

defaults = {
    'PHITBIT_AUTH_MESSAGE': PHITBIT_AUTH_MESSAGE,
    'PHITBIT_SUCCESS_REDIRECT': PHITBIT_SUCCESS_REDIRECT,
    'PHITBIT_ERROR_REDIRECT': PHITBIT_ERROR_REDIRECT
}


def get_setting(s):
    if hasattr(settings, s):
        return getattr(settings, s)
    else:
        return defaults[s]
    msg = '%s must be set in settings', s
    raise ImproperlyConfigured(msg)
