from __future__ import unicode_literals

try:
    from cStringIO import StringIO
except ImportError:  # pragma: no cover
    from io import StringIO

from django.test import TestCase
from pipedash.exceptions import PipedashProcessorError
from pipedash.finders import PipedashFinder
from pipedash.processor import BaseProcessor


class NonZeroExitProcessor(BaseProcessor):

    input_mime = 'text/javascript'
    output_mime = 'text/javascript'
    command = ['bash', '-c', 'exit 1']


class InvalidProcessor(BaseProcessor):
    pass


class TestNonZeroExitProcessor(TestCase):

    def setUp(self):
        self.finder = PipedashFinder(
            concat=False,
            compressors=(
                'tests.test_processor.NonZeroExitProcessor',
            ),
        )

    def test_non_zero_exit(self):
        with self.assertRaises(PipedashProcessorError):
            self.finder.list(None)


class TestInvalidProcessor(TestCase):

    def setUp(self):
        self.file = StringIO()
        self.processor = InvalidProcessor(self.file)

    def test_invalid_processor_raises_exception(self):
        for attr in ['input_mime', 'output_mime', 'command']:
            with self.assertRaises(NotImplementedError):
                getattr(self.processor, attr)
