from __future__ import unicode_literals

from django import template
from django.test import TestCase
from pipedash.templatetags.pipedash import PipedashNode


class TestConcatPipedashNode(TestCase):

    def test_concat_css(self):
        self.assertEqual(
            PipedashNode("'css:index'", concat=True).render(template.Context()),
            '<link href="/static/css/main.css" type="text/css" media="screen">'
        )

    def test_concat_js(self):
        self.assertEqual(
            PipedashNode("'js:index'", concat=True).render(template.Context()),
            '<script src="/static/js/main.js" type="text/javascript" async="async"></script>'
        )

    def test_concat_no_attrs(self):
        self.assertEqual(
            PipedashNode("'css:concat'", concat=True).render(template.Context()),
            '<link href="/static/css/contact.css" type="text/css">'
        )


class TestNonConcatPipedashNode(TestCase):

    def test_non_concat_css(self):
        self.assertEqual(
            PipedashNode("'css:index'", concat=False).render(template.Context()),
            '<link href="/static/css/red.css" type="text/css" media="screen">\n'
            '<link href="/static/css/blue.css" type="text/css" media="screen">\n'
            '<link href="/static/less/green.less" type="text/css" media="screen">'
        )

    def test_non_concat_js(self):
        self.assertEqual(
            PipedashNode("'css:index'", concat=False).render(template.Context()),
            '<link href="/static/css/red.css" type="text/css" media="screen">\n'
            '<link href="/static/css/blue.css" type="text/css" media="screen">\n'
            '<link href="/static/less/green.less" type="text/css" media="screen">'
        )


class TestNonConcatNoProcessorsPipedashNode(TestCase):

    def test_non_concat_css(self):
        node = PipedashNode("'css:index'", concat=False, compressors=None, compilers=None)
        self.assertEqual(
            node.render(template.Context()),
            '<link href="/static/css/red.css" type="text/css" media="screen">\n'
            '<link href="/static/css/blue.css" type="text/css" media="screen">\n'
            '<link href="/static/less/green.less" type="text/less" media="screen">'
        )

    def test_non_concat_js(self):
        node = PipedashNode("'js:index'", concat=False, compressors=None, compilers=None)
        self.assertEqual(
            node.render(template.Context()),
            '<script src="/static/js/foo.js" type="text/javascript" async="async"></script>\n'
            '<script src="/static/js/bar.js" type="text/javascript" async="async"></script>'
        )


class TestPipedashTag(TestCase):

    def test_correct_params_css(self):
        _template = template.Template("{% load pipedash %}{% pipedash 'css:index' %}")
        self.assertEqual(
            _template.render(template.Context()),
            '<link href="/static/css/main.css" type="text/css" media="screen">'
        )

    def test_correct_params_js(self):
        _template = template.Template("{% load pipedash %}{% pipedash 'js:index' %}")
        self.assertEqual(
            _template.render(template.Context()),
            '<script src="/static/js/main.js" type="text/javascript" async="async"></script>'
        )

    def test_incorrect_param(self):
        _template = template.Template("{% load pipedash %}{% pipedash 'nonexistant' %}")
        self.assertEqual(
            _template.render(template.Context()),
            ''
        )

    def test_missing_param(self):
        with self.assertRaises(template.TemplateSyntaxError):
            template.Template("{% load pipedash %}{% pipedash %}").render(template.Context())
