from __future__ import unicode_literals

import os

BASE_PATH = os.path.abspath(os.path.dirname(__file__))


DEBUG_PROPAGATE_EXCEPTIONS = True

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:'
    }
}

SITE_ID = 1

SECRET_KEY = 'not very secret in tests'

USE_I18N = True

USE_L10N = True

STATIC_URL = '/static/'

ROOT_URLCONF = 'tests.urls'

TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'pipedash',
    'tests',
)

PASSWORD_HASHERS = (
    'django.contrib.auth.hashers.SHA1PasswordHasher',
    'django.contrib.auth.hashers.PBKDF2PasswordHasher',
    'django.contrib.auth.hashers.PBKDF2SHA1PasswordHasher',
    'django.contrib.auth.hashers.BCryptPasswordHasher',
    'django.contrib.auth.hashers.MD5PasswordHasher',
    'django.contrib.auth.hashers.CryptPasswordHasher',
)

STATICFILES_DIRS = (
    os.path.join(BASE_PATH, 'static1'),
    os.path.join(BASE_PATH, 'static2'),
)

STATICFILES_FINDERS = (
    "pipedash.finders.PipedashFinder",
    "django.contrib.staticfiles.finders.FileSystemFinder",
    "django.contrib.staticfiles.finders.AppDirectoriesFinder",
)
TEST_RUNNER = 'django.test.runner.DiscoverRunner'

PIPEDASH_COMPILERS = (
    'pipedash.compilers.LessCompiler',
)

PIPEDASH_COMPRESSORS = (
    'pipedash.compressors.CssminCompressor',
)

PIPEDASH_PACKAGES = {
    'js:index': {
        'path': 'js/main.js',
        'mime': 'text/javascript',
        'attrs': {
            'async': 'async',
        },
        'files': [
            ('js/foo.js', 'text/javascript'),
            ('js/bar.js', 'text/javascript'),
        ],
    },
    'css:index': {
        'path': 'css/main.css',
        'mime': 'text/css',
        'attrs': {
            'media': 'screen',
        },
        'files': [
            ('css/red.css', 'text/css'),
            ('css/blue.css', 'text/css'),
            ('less/green.less', 'text/less'),
        ]
    },
    'css:concat': {
        'path': 'css/contact.css',
        'mime': 'text/css',
        'files': [
            ('less/green.less', 'text/less'),
        ]
    }
}
