from __future__ import unicode_literals

try:
    import subprocess32 as subprocess
except ImportError:  # pragma: no cover
    import subprocess

from pipedash.exceptions import PipedashProcessorError


class BaseProcessor(object):

    def __init__(self, content=None, resolved_path=None):
        self.content = content
        self.resolved_path = resolved_path

    @property
    def command(self):
        raise NotImplementedError

    @property
    def input_extension(self):
        raise NotImplementedError

    @property
    def output_extension(self):
        raise NotImplementedError

    def execute_command(self, command):
        """
        Pipes the current content to the command stdin and then returns the stdout
        Raises an exception if the subprocess returned a non 0 return code
        """
        proc = subprocess.Popen(command, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)

        stdout, stderr = proc.communicate(self.content)

        if proc.returncode != 0:
            stderr = stderr.strip()
            if not stderr:
                stderr = 'Non 0 return code: %s' % proc.returncode
            raise PipedashProcessorError(stderr)

        return stdout

    def run(self):
        return self.execute_command(self.command)
