from __future__ import unicode_literals

import tempfile
from django.core.files.storage import FileSystemStorage
from pipedash import settings


class TemporaryFileSystemStorage(FileSystemStorage):

    def __init__(self, *arg, **kwargs):
        kwargs['location'] = tempfile.mkdtemp(prefix='pipedash-')
        kwargs['base_url'] = settings.STATIC_URL
        super(TemporaryFileSystemStorage, self).__init__(*arg, **kwargs)
