import os
import re
import codecs
from setuptools import setup, find_packages
import sys


def read(*parts):
    filename = os.path.join(os.path.dirname(__file__), *parts)
    with codecs.open(filename, encoding='utf-8') as fp:
        return fp.read()


def find_version(*file_paths):
    version_file = read(*file_paths)
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")

install_requires = ['subprocess32>=3.2.6'] if sys.version_info < (3,) else []

setup(
    name="django-pipedash",
    version=find_version("pipedash", "__init__.py"),
    url='https://github.com/leonsmith/django-pipedash/',
    license='BSD',
    description="A simple offline asset pipeline for Django using a static files finder",
    long_description=read('README.rst'),
    author='Leon Smith',
    author_email='_@leonmarksmith.com',
    packages=find_packages(exclude=['tests', 'tests.*']),
    include_package_data=True,
    install_requires=install_requires,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Utilities',
    ],
    zip_safe=False,
)