from __future__ import unicode_literals

from django import template
from django.test import TestCase
from pipedash.templatetags.pipedash import PipedashNode


class TestConcatPipedashNode(TestCase):

    def test_concat_css(self):
        self.assertEqual(
            PipedashNode("'css:index'", concat=True).render(template.Context()),
            '<link rel="stylesheet" type="text/css" href="/static/css/main.css" media="screen">'
        )

    def test_concat_js(self):
        self.assertEqual(
            PipedashNode("'js:index'", concat=True).render(template.Context()),
            '<script type="text/javascript" src="/static/js/main.js" async="async"></script>'
        )

    def test_concat_no_attrs(self):
        self.assertEqual(
            PipedashNode("'css:concat'", concat=True).render(template.Context()),
            '<link rel="stylesheet" type="text/css" href="/static/css/contact.css">'
        )


class TestNonConcatPipedashNode(TestCase):

    def test_non_concat_css(self):
        self.assertEqual(
            PipedashNode("'css:index'", concat=False).render(template.Context()),
            '<link rel="stylesheet" type="text/css" href="/static/css/red.css" media="screen">\n'
            '<link rel="stylesheet" type="text/css" href="/static/css/blue.css" media="screen">\n'
            '<link rel="stylesheet" type="text/css" href="/static/less/green.less.css" media="screen">\n'
            '<link rel="stylesheet" type="text/css" href="/static/sass/john.sass.css" media="screen">'
        )

    def test_non_concat_js(self):
        self.assertEqual(
            PipedashNode("'js:index'", concat=False).render(template.Context()),
            '<script type="text/javascript" src="/static/js/foo.js" async="async"></script>\n'
            '<script type="text/javascript" src="/static/js/bar.js" async="async"></script>'
        )


class TestNonConcatNoProcessorsPipedashNode(TestCase):

    def test_non_concat_css(self):
        node = PipedashNode("'css:index'", concat=False, compressors=None, compilers=None)
        self.assertEqual(
            node.render(template.Context()),
            '<link rel="stylesheet" type="text/css" href="/static/css/red.css" media="screen">\n'
            '<link rel="stylesheet" type="text/css" href="/static/css/blue.css" media="screen">\n'
            '<link rel="stylesheet/less" type="text/css" href="/static/less/green.less" media="screen">\n'
            '<link rel="stylesheet" type="text/x-sass" href="/static/sass/john.sass" media="screen">'
        )

    def test_non_concat_js(self):
        node = PipedashNode("'js:index'", concat=False, compressors=None, compilers=None)
        self.assertEqual(
            node.render(template.Context()),
            '<script type="text/javascript" src="/static/js/foo.js" async="async"></script>\n'
            '<script type="text/javascript" src="/static/js/bar.js" async="async"></script>'
        )


class TestPipedashTag(TestCase):

    def test_correct_params_css(self):
        _template = template.Template("{% load pipedash %}{% pipedash 'css:index' %}")
        self.assertEqual(
            _template.render(template.Context()),
            '<link rel="stylesheet" type="text/css" href="/static/css/main.css" media="screen">'
        )

    def test_correct_params_js(self):
        _template = template.Template("{% load pipedash %}{% pipedash 'js:index' %}")
        self.assertEqual(
            _template.render(template.Context()),
            '<script type="text/javascript" src="/static/js/main.js" async="async"></script>'
        )

    def test_incorrect_param(self):
        _template = template.Template("{% load pipedash %}{% pipedash 'nonexistant' %}")
        self.assertEqual(
            _template.render(template.Context()),
            ''
        )

    def test_missing_param(self):
        with self.assertRaises(template.TemplateSyntaxError):
            template.Template("{% load pipedash %}{% pipedash %}").render(template.Context())
