from django.contrib import admin


class ModelAdmin(admin.ModelAdmin):
    list_display = ('id', '__unicode__', 'is_deleted')
    list_display_filter = ('is_deleted', )

    def queryset(self, request):
        qs = self.model._default_manager.with_deleted()
        ordering = self.ordering or ()
        if ordering:
            qs = qs.order_by(*ordering)
        return qs
