# -*- encoding: utf-8 -*-
# Django settings for {{ project_name }} project.

from player.settings import *  # pyflakes:ignore

from os import path

ugettext = lambda s: s  # dummy ugettext function, as said on django docs

BASEDIR = path.dirname(path.abspath(__file__))

DEBUG = True
TEMPLATE_DEBUG = DEBUG
DEBUG_TOOLBAR = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',  # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'database.db',                   # Or path to database file if using sqlite3.
        'USER': '',                              # Not used with sqlite3.
        'PASSWORD': '',                          # Not used with sqlite3.
        'HOST': '',                              # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                              # Set to empty string for default. Not used with sqlite3.
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Madrid'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'es'

LANGUAGES = (
    ('es', ugettext('Español')),
    ('en', ugettext('English')),
    ('fr', ugettext('Français')),
)

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = path.join(BASEDIR, 'media')


# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = path.join(BASEDIR, 'static_root')

PROJECT_STATIC_ROOT = path.join(BASEDIR, 'static')

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    PROJECT_STATIC_ROOT,
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
#    'django.contrib.staticfiles.finders.DefaultStorageFinder',
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'as!awi8ty*^0=im+%^6!m=q*xcjm@*lv2p5k0@#39-8y8vb0wf'

MIDDLEWARE_CLASSES += (
    # put here your project middlewares
    'staging.middleware.XsSharing',
)

ROOT_URLCONF = '{{ project_name }}.urls'

TEMPLATE_DIRS += (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    path.join(BASEDIR, 'templates'),
)

TEMPLATE_CONTEXT_PROCESSORS += (
    # put here your project context processors
)

INSTALLED_APPS += (
    # example apps
    'items',
    'news',
    'website',
)

INLINETRANS_MEDIA_URL = STATIC_URL + 'inlinetrans/'

# A sample logging configuration. The only tangible logging
# performed by this configuration is to send an email to
# the site admins on every HTTP 500 error.
# See http://docs.djangoproject.com/en/dev/topics/logging for
# more details on how to customize your logging configuration.
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler'
        }
    },
    'loggers': {
        'django.request': {
            'handlers': ['mail_admins'],
            'level': 'ERROR',
            'propagate': True,
        },
    }
}

# filebrowser settings
FILEBROWSER_MEDIA_ROOT = PROJECT_STATIC_ROOT
FILEBROWSER_DIRECTORY = ''
FILEBROWSER_MEDIA_URL = STATIC_URL

# django-playerlayer specific settings
CRAWLER_BACKEND = 'player.crawler.backends.mozenda'
CRAWLER_HOST = 'https://api.mozenda.com/rest'
CRAWLER_LOGIN = '9C4A9E46-9986-4A2D-8E28-5218F486AA40'
CRAWLER_PASSWORD = ''

# staging settings
STAGING_REPO_DIR = path.join(BASEDIR, 'repo')
