# vim: set ts=8 sw=4 sts=4 et ai tw=79 syn=python:
"""
Example WSGI config for django-pstore project.

This module contains the WSGI application used by Django's development server
and any production WSGI deployments. It should expose a module-level variable
named ``application``. Django's ``runserver`` and ``runfcgi`` commands discover
this application via the ``WSGI_APPLICATION`` setting.

Usually you will have the standard Django WSGI application here, but it also
might make sense to replace the whole Django WSGI application with a custom one
that later delegates to the Django one. For example, you could introduce WSGI
middleware here, or combine a Django application with an application of another
framework.

"""
import os
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'pstore.settings')

###############################################################################
# NOTE: If you're using virtualenv(1) to manage your python dependencies, you
# can set the sys.path from your project virtualenv here:
#import sys
#sys.path[:] = [/* different path list */]
###############################################################################

# This application object is used by any WSGI server configured to use this
# file. This includes Django's development server, if the WSGI_APPLICATION
# setting points here.
try:
    from django.core.wsgi import get_wsgi_application
except ImportError:  # django1.3- ?
    from django.core.handlers.wsgi import WSGIHandler as get_wsgi_application
application = get_wsgi_application()
